
#include <pthread.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "RootDaemonTestUtils.h"
#include "ShellCmd.h"

int fork_loop() {

    int res;

    res = fork();

    if (res == 0) {
        while(1) { /* Do nothing */
            int i = 0;
            i++;
        }
    }

    return res;
}

int wait_for_process(int pid){
    int status;
    while (-1 == waitpid(pid, &status, 0)) {
        if (EINTR != errno){
            break;
        }
    }
    return status;
}

std::string dump_errmem() {
    ShellCmd cmd("errmemd");
    std::string output;

    cmd.addArgs(std::string("-s /var/opt/bosch/persistent/errmem"));
    cmd.addArgs(std::string("-C dump"));

    cmd.setOutputPipe(true);

    cmd.exec();

    output = cmd.getCommandOutput();

    return output;
}

int erase_errmem() {
    ShellCmd cmd("errmemd");
    std::string output;
    int res;

    cmd.addArgs(std::string("-s /var/opt/bosch/persistent/errmem"));
    cmd.addArgs(std::string("-C erase"));

    res = cmd.exec();

    return res;
}

bool file_exists(const std::string &filepath) {
    return (access(filepath.c_str(), F_OK) != -1);
}
