/*
 * RootDaemonTypes.h
 *
 *  This file defines structs that are used used to exchange commands and commands result between root daemon clients and root daemon server
 *
 *  Created on: Oct 24, 2014
 *      Author: Mohamed Mostafa
 */
 
#ifndef _ROOT_DAEMON_TYPES_H_
#define _ROOT_DAEMON_TYPES_H_

//This struct is used to exchange a command or a command result over a pipe
typedef struct 
{
	int cmdDataSize;
	int cmdNo;
	int errorNo;
	char message[4096];
} CmdData;

enum
{
	ERR_NONE = 0,
	ERR_UNKNOWN_CMD = 1,
	ERR_NO_CMD_PIPE = 2,
	ERR_NO_RESULT_PIPE = 3,
	ERR_WRITE_TO_CMD_PIPE = 4,
	ERR_WRITE_TO_RESULT_PIPE = 5,
	ERR_READ_FROM_CMD_PIPE = 6,
	ERR_READ_FROM_RESULT_PIPE = 7,
	ERR_INCOMPLETE_DATA_IN_PIPE = 8,
	ERR_PIPE_SELECT = 9,
   ERR_INVALID_CMD_ARGS = 10,
   ERR_CANNOT_EXEC_CMD = 11,
   ERR_CANNOT_OPEN_RESULT_FILE = 12,
   ERR_CANNOT_PARSE_RESULT_FILE = 13,
};

#endif //#ifndef _ROOT_DAEMON_TYPES_H_
