#ifndef NATIVE_TEST_COMPONET_DEFINES_H
#define NATIVE_TEST_COMPONET_DEFINES_H

#include<string.h>

// Ports defined as per the dbus service connectors
#define NATIVE_COMPONENT_SERV1_PORT			"NativeService1Port"
#define NATIVE_COMPONENT_SERV2_PORT 		"NativeService2Port"

// files,bins for the test cases
#define NATIVE_SOCKET_SERVER_BIN			"/opt/bosch/containertest/native_test_server"
#define NATIVE_SOCKET_SERVER_HOME			"HOME=/home/pj_tcu"
#define NATIVE_SOCKET_SERVER_PATH			"PATH=/bin:/usr/bin:/sbin:/usr/sbin"
#define NATIVE_SOCKET_SERVER_USER			"USER=pj_tcu"
#define NATIVE_SOCKET_SERVER_LOG			"LOGNAME=/home/pj_tcu/sockserver.log"

// shared, mount points
#define NAVISHARED_SHARED_POINT				"/var/opt/bosch/dynamic/navishared/"
#define NAVISHARED_MOUNT_POINT				"/var/lib/lxc/agent_media/rootfs/var/opt/bosch/dynamic/navishared/"

// mount commands
#define NAVISHARED_MOUNT	   				"/opt/bosch/containertest/mount mount"
#define NAVISHARED_UMOUNT					"/opt/bosch/containertest/mount umount"


// DLT tracing
#define DEBUG_TRACE(format)			_DEBUG_TRACE format

#define _DEBUG_TRACE(format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    snprintf(final_string, sizeof(final_string),"File:%s, LINE:%d, ",__FILE__, __LINE__); \
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string)); \
    DLT_LOG(NATIVE_TEST_COMPONENT, DLT_LOG_INFO, DLT_STRING(final_string)); \
} while(0)

#endif