#ifndef TESTCOMPONENT_DEFINES_H
#define TESTCOMPONENT_DEFINES_H

#include<string.h>

// Ports defined as per the dbus service connectors
#define NATIVE_COMPONENT_SERV1_PORT			"NativeService1Port"
#define NATIVE_COMPONENT_SERV2_PORT 		"NativeService2Port"
#define CMANAGER_PORT						"cManagerPort"
#define CSESSION_PORT						"cSessionPort"
#define CNOTIFICATION_PORT 					"cNotificationPort"
#define AGW_LCM_PROXY_PORT			    	"LCMProxyPort"
#define AGW_AM_PROXY_PORT					"AMProxyPort"
#define CNOTIFICATION_BUS_ADDRESS 			"/org/bosch/cm/ai_security/TestContainerComponentNotification"

// files,bins for the test cases
#define TEST_CASE_CONFIG_FILE 				"/home/lxc_agent_media/TestConfig.xml"
#define TEST_CASE_BIN_SLAVE					"/opt/bosch/agent_media/slave"
#define TEST_CASE_BIN_MEMLEAK				"/opt/bosch/agent_media/memleak"
#define TEST_CASE_BIN_STRESS				"/opt/bosch/agent_media/stress"
#define TEST_CASE_BIN_ISORESTART			"/opt/bosch/agent_media/isorestart"

// Slave exec parameters specification
#define TEST_CONTAINER_SOCKET				"/tmp/shared/agent_media_private/lxc.sock"
#define TEST_CONTAINER_TEST_FILE			"/test.txt"
#define TEST_CONTAINER_SLAVE_HOME			"HOME=/home/lxc_agent_media"
#define TEST_CONTAINER_SLAVE_PATH			"PATH=/bin:/usr/bin:/sbin:/usr/sbin"
#define TEST_CONTAINER_SLAVE_USER			"USER=lxc_agent_media"
#define TEST_CONTAINER_SLAVE_LOG			"LOGNAME=/home/lxc_agent_media/slave.log"

// XML tags specification for the TestConfig test cases ---
#define TEST_CASE_BASE_TAG					"TestCase"
#define TEST_CASE_ATTR_TYPE					"type"
#define TEST_CASE_ATTR_SERVICE				"service"
#define TEST_CASE_ATTR_METHOD				"method"
#define TEST_CASE_ATTRVAL_SOCKET			"socket"
#define TEST_CASE_ATTRVAL_DBUS				"dbus"
#define TEST_CASE_ATTRVAL_NETWORK           "network"
#define TEST_CASE_ATTR_SUBTEST				"subtest"
#define TEST_CASE_ATTRVAL_SUBTEST_SSC       "ssc"
#define TEST_CASE_ATTRVAL_SUBTEST_MSC       "msc"
#define TEST_CASE_ATTRVAL_SUBTEST_HTTP_GET  "http_get"
#define TEST_CASE_ATTRVAL_SUBTEST_SLAVE		"slave"
#define TEST_CASE_ATTRVAL_SUBTEST_MEMLEAK	"memleak"
#define TEST_CASE_ATTRVAL_SUBTEST_STRESS	"stress"
#define TEST_CASE_ATTRVAL_SERVICE_1			"navishare"
#define TEST_CASE_ATTRVAL_SERVICE_2			"service2"
#define TEST_CASE_ATTRVAL_METHOD_1			"mount"
#define TEST_CASE_ATTRVAL_METHOD_2			"umount"
#define	TEST_CASE_ATTRVAL_FILECREATE		"file"
#define TEST_CASE_ATTR_FILECLOSE			"close"
#define TEST_CASE_ATTRVAL_FILECLOSE			"true"
#define TEST_CASE_ATTR_FOLDER				"folder"
#define TEST_CASE_ATTRVAL_LCM_REG			"lcm"
#define TEST_CASE_ATTRVAL_AUDIO				"audio"
#define TEST_CASE_ATTRVAL_SUBTEST_AUD_ALLOC "allocate"

// XML tags specification for Restart values/default
#define TEST_CASE_RESET_TIMER				"TestTimerConfig"
#define TEST_CASE_ATTRVAL_TIME				"val"
#define TEST_CASE_RESTART_SEC_DEFAULT		60

// DLT Injection-ID specification for customized handling
#define TEST_DLT_COMMAND_ID_01 				0x1010

// DLT Macro
#define DEBUG_TRACE(format)			_DEBUG_TRACE format

#define _DEBUG_TRACE(ctx,format,args...) do { \
    char log_buff[1024]; \
    char final_string[1024]; \
    snprintf(final_string, sizeof(final_string),"File:%s, LINE:%d, ",__FILE__, __LINE__); \
    snprintf(log_buff, sizeof(log_buff), format,##args); \
    strncat(final_string, log_buff, sizeof(final_string)); \
    DLT_LOG(ctx, DLT_LOG_INFO, DLT_STRING(final_string)); \
} while(0)



#endif
