/*************************************************************************************************
 FILE:           scd_ssc_test.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    test class definition
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 10.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#include "scd_ssc_test.h"

/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
scd_ssc_tclTest::scd_ssc_tclTest() {
	// TODO Auto-generated constructor stub

}

/*************************************************************************************************
	FUNCTION:
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION:

	HISTORY:
    Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
scd_ssc_tclTest::~scd_ssc_tclTest() {
	// TODO Auto-generated destructor stub
}


/*************************************************************************************************
	FUNCTION: run_ald_challenge_test
	PARAMETERS: m_poClientHandlerALD, m_poProperty
	RETURN VALUE:
	DESCRIPTION: get challenge data and show it on a terminal

	HISTORY:
	Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclTest::run_ald_challenge_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
		                       scd_ssc_tclProperty *m_poProperty, scd_ssc_tclLogger  *m_poLogger)
{
	std::cout << "entering scd_ssc_tclTest -> run_ald_challenge_test() ..."<< std::endl;
	unsigned int x = 0;

	if(m_poClientHandlerALD->challenge(m_poProperty, m_poLogger))
	{
		char *ptr_test = m_poProperty->getAldChallengeOut();
		std::cout << "challenge data:" << std::endl;

		for(x = 0; x < m_poProperty->getAldChallengeSize(); x++)
		{
			if(x != 0 && (x % 6 == 0)){std::cout << "\n";}
			std::cout << "b" << x << " data: "<< ptr_test[x] << "  ";
		}
		std::cout << "\nchallenge() function succeeded !" << std::endl;
	}else{std::cout << "\nchallenge() function failed !" << std::endl;}

	std::cout << "exiting scd_ssc_tclTest -> run_ald_challenge_test()"<< std::endl;

}

/*************************************************************************************************
	FUNCTION: run_smartcard_discovery_test
	PARAMETERS: m_poSmartcardHandler
	RETURN VALUE:
	DESCRIPTION: pull data (attributes from the wibu smartcard and save it on a file/terminal

	HISTORY:
	Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclTest::run_smartcard_discovery_test(scd_ssc_tclSmartcardHandler *m_poSmartcardHandler,
		                                           scd_ssc_tclLogger  *m_poLogger)
{
	std::cout << "entering scd_ssc_tclTest -> run_smartcard_discovery_test() ..."<< std::endl;
	std::ofstream myfile;

	if(m_poSmartcardHandler->getAttributes() )
	{
		myfile.open("/tmp/CM_SMARTCARD.txt", std::ios::app);
		if(myfile.is_open())
		{
			std::cout << "Vendor ID: " << m_poSmartcardHandler->getVendorId() << std::endl;
		    std::cout << "Product ID: " << m_poSmartcardHandler->getProductId() << std::endl;
			std::cout << "Manufacturer: " << m_poSmartcardHandler->getManufacturer() << std::endl;
		    std::cout << "Product:  " << m_poSmartcardHandler->getProduct() << std::endl;
			std::cout << "Serial Number: " << m_poSmartcardHandler->getSerial() << std::endl;

			myfile << "Vendor ID: " << m_poSmartcardHandler->getVendorId() << std::endl;
			myfile << "Product ID: " << m_poSmartcardHandler->getProductId() << std::endl;
			myfile << "Manufacturer: " << m_poSmartcardHandler->getManufacturer() << std::endl;
			myfile << "Product:  " << m_poSmartcardHandler->getProduct() << std::endl;
			myfile << "Serial Number: " << m_poSmartcardHandler->getSerial() << std::endl;
			myfile.close();

		}else{std::cerr << "\nfile is not opened !\n" << std::endl;}
	}else{std::cerr << "\nno device connected to the system !\n" << std::endl;}

	std::cout << "exiting scd_ssc_tclTest -> run_smartcard_discovery_test()"<< std::endl;


}

/*************************************************************************************************
	FUNCTION: run_ald_smartcard_challenge_response_test
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: test the challenge method and construction of response (1400 bytes)

	HISTORY:
    Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclTest::run_ald_smartcard_challenge_response_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
		scd_ssc_tclProperty *m_poProperty, scd_ssc_tclUtility  *m_poUtility,
		scd_ssc_tclSmartcardHandler *m_poSmartcardHandler, scd_ssc_tclLogger  *m_poLogger)
{
	std::cout << "entering scd_ssc_tclTest -> run_ald_smartcard_challenge_response_test() ..."<< std::endl;

	/* 1. get challenge data                                                                    */
	if(m_poClientHandlerALD->challenge(m_poProperty, m_poLogger))
	{
		if(m_poSmartcardHandler->initialize(m_poProperty, m_poLogger))
		{
			int x = 0;
			char *ptr;
			ptr = m_poProperty->getResponseIn();
			std::cout <<"\nthe content of the response (before sent to ALD): \n" << std::endl;
			for(x = 0; x < m_poProperty->getResponseSize(); x++)
			{
				if(x != 0 && (x % 6 == 0)){std::cout << "\n";}
				std::cout << "b:" << x << " data: "<< *ptr++ << "  ";
			}
		}else{std::cout << "\nrun_ald_smartcard_challenge_response_test - initialize() failed\n"  << std::endl;}
	}else{std::cout << "\nrun_ald_smartcard_challenge_response_test - challenge() failed\n"  << std::endl;}

	std::cout << "exiting scd_ssc_tclTest -> run_ald_smartcard_challenge_response_test()"<< std::endl;

}

/*************************************************************************************************
	FUNCTION: run_codemeter_initialization_test
	PARAMETERS: m_poClientHandlerALD, m_poProperty
	RETURN VALUE:
	DESCRIPTION: get response data and show it on a terminal

	HISTORY:
	Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclTest::run_codemeter_initialization_test(scd_ssc_tclSmartcardHandler *m_poSmartcardHandler,
		scd_ssc_tclProperty *m_poProperty, scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
		                                                scd_ssc_tclLogger  *m_poLogger)
{
	std::cout << "entering scd_ssc_tclTest -> run_codemeter_initialization_test() ..."<< std::endl;
	if(m_poClientHandlerALD->challenge(m_poProperty, m_poLogger))
	{
		std::ofstream myfile1, myfile2, myfile3, myfile4, myfile5, myfile6;
		myfile1.open("/tmp/CHALLENGE.txt", std::ios::out);
		unsigned int x;

		if(myfile1.is_open())
		{
			char *ptr_test = m_poProperty->getAldChallengeOut();
			for(x = 0; x < m_poProperty->getAldChallengeSize(); x++)
			{
				myfile1 << ptr_test[x];
			}
			myfile1.close();
		}

		if(m_poSmartcardHandler->initialize(m_poProperty, m_poLogger))
		{
			myfile2.open("/tmp/RESPONSE.txt", std::ios::out);
			myfile3.open("/tmp/SERIALNO.txt", std::ios::out);
			myfile4.open("/tmp/LOCKLVL.txt", std::ios::out);
			myfile5.open("/tmp/PUBKEY.txt", std::ios::out);
			myfile6.open("/tmp/SIGNATURE.txt", std::ios::out);

			unsigned char *serial = m_poProperty->getSerial();
			unsigned char *lock_level = m_poProperty->getLockLevel();
			unsigned char *key = m_poProperty->getPublicKey();
			unsigned char *signature = m_poProperty->getSignature();

			std::cout << "\nSerial number: ";
			for(x = 0; x < m_poProperty->getSerialSize(); x++)
			{
				std::cout << serial[x];
				if(myfile3.is_open())
				{
					myfile3 << serial[x];
				}
			}
			myfile3.close();
			std::cout << "\nLock Level: ";
			for(x = 0; x < m_poProperty->getRequestUnlockLevelSize(); x++)
			{
				std::cout << lock_level[x];
				if(myfile4.is_open())
				{
					myfile4 << lock_level[x];
				}
			}
			myfile4.close();

			std::cout << "\nPublic Key: " << std::endl;
			for(x = 0; x <m_poProperty->getPublicKeyUserSize(); x++)
			{
				if(x != 0 && (x % 100 == 0)){std::cout << "\n";}
				std::cout << key[x];
				if(myfile5.is_open())
				{
					myfile5 << key[x];
				}
			}
			myfile5.close();

			std::cout << "\nSignature: "<< std::endl;
			for(x = 0; x <m_poProperty->getSignatureSize(); x++)
			{
				if(x != 0 && (x % 100 == 0)){std::cout << "\n";}
				std::cout << signature[x];

			    if(myfile6.is_open())
				{
					myfile6 << signature[x];
				}
			}
			myfile6.close();

			if(myfile2.is_open())
			{
				char *ptr_test = m_poProperty->getResponseIn();
				std::cout << "\n\nResponse: ";
				for(x = 0; x < m_poProperty->getResponseSize(); x++)
				{
					myfile2 << ptr_test[x];
					if(x != 0 && (x % 100 == 0)){std::cout << "\n";}
					std::cout << ptr_test[x];
				}
				myfile2.close();
			}
			std::cout << "\nrun_codemeter_initialization_test() succeeded !!\n"<< std::endl;
		}
		else
		{
			std::cout << "\nrun_codemeter_initialization_test() failed !!\n"<< std::endl;
		}
	}
	std::cout << "exiting scd_ssc_tclTest -> run_codemeter_initialization_test()"<< std::endl;

}

/*************************************************************************************************
	FUNCTION: run_ald_get_status_test
	PARAMETERS: m_poClientHandlerALD, m_poProperty
	RETURN VALUE:
	DESCRIPTION: get the current lock level

	HISTORY:
	Date        | Author                | Modification
    10.10.2015  | sva1fh                | initial version

*************************************************************************************************/
void scd_ssc_tclTest::run_ald_get_status_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
		                        scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger)
{
	std::cout << "entering scd_ssc_tclTest -> run_ald_get_status_test() ..."<< std::endl;

	if(m_poClientHandlerALD->getStatus(ald_property, m_poLogger))
	{
		scd_ssc_tclUtility util;
		char * ch = (char *)(ald_property->getCurrentLockLevel());
		std::string str(ch);
		int level = util.stringToInt(str);
		std::cout << "the current lock level: " << level << std::endl;
		std::cout << "run_ald_get_status_test() succeeded" << std::endl;
	}
	else
	{
		std::cout << "\ngetStatus failed" << std::endl;
	}
	std::cout << "exiting scd_ssc_tclTest -> run_ald_get_status_test()"<< std::endl;

}

