/*************************************************************************************************
 FILE:           scd_ssc_smartcardhandler.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:
 DESCRIPTION:    Definition of the smartcard client class
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#include "scd_ssc_smartcardhandler.h"

/*************************************************************************************************
* FUNCTION: scd_ssc_tclSmartcardHandler
* DESCRIPTION: Constructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclSmartcardHandler::scd_ssc_tclSmartcardHandler()
{
	m_poCCodeMeter 	= new CCodeMeter(0, 0);
	vendor_id   	= new char[VENDOR_ID_SIZE];
	product_id   	= new char[PRODUCT_ID_SIZE];
	manufacturer 	= new char[MANUFACTURER_SIZE];
	product      	= new char[PRODUCT_SIZE];
	serial       	= new char[SERIAL_SIZE];
}

/*************************************************************************************************
* FUNCTION: scd_ssc_tclSmartcardHandler
* DESCRIPTION: Copy constructor
* PARAMETER: scd_ssc_tclSmartcardHandler
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclSmartcardHandler::scd_ssc_tclSmartcardHandler(const scd_ssc_tclSmartcardHandler & osmartcard)
{
	m_poCCodeMeter 	= new CCodeMeter(0, 0);

	vendor_id    	= new char[VENDOR_ID_SIZE];
	product_id   	= new char[PRODUCT_ID_SIZE];
	manufacturer 	= new char[MANUFACTURER_SIZE];
	product      	= new char[PRODUCT_SIZE];
	serial       	= new char[SERIAL_SIZE];

	vendor_id    	= osmartcard.vendor_id;
	product_id   	= osmartcard.product_id;
	manufacturer 	= osmartcard.manufacturer;
	product      	= osmartcard.product;
	serial       	= osmartcard.serial;
}

/*************************************************************************************************
* FUNCTION: operator=
* DESCRIPTION: Assignment operator
* PARAMETER: scd_ssc_tclSmartcardHandler &
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclSmartcardHandler & scd_ssc_tclSmartcardHandler::operator=(const scd_ssc_tclSmartcardHandler & osmartcard)
{
	if(this == &osmartcard)
	{
		return (*this);
	}
	else
	{
		delete(m_poCCodeMeter);

		delete[]vendor_id;
		delete[]product_id;
		delete[]manufacturer;
		delete[]product;
		delete[]serial;

		m_poCCodeMeter 	= new CCodeMeter(0, 0);
		vendor_id    	= new char[VENDOR_ID_SIZE];
		product_id   	= new char[PRODUCT_ID_SIZE];
		manufacturer 	= new char[MANUFACTURER_SIZE];
		product      	= new char[PRODUCT_SIZE];
		serial       	= new char[SERIAL_SIZE];

		vendor_id    	= osmartcard.vendor_id;
		product_id   	= osmartcard.product_id;
		manufacturer 	= osmartcard.manufacturer;
		product      	= osmartcard.product;
		serial       	= osmartcard.serial;

		return (*this);
	}
}

/*************************************************************************************************
* FUNCTION: ~scd_ssc_tclSmartcardHandler
* DESCRIPTION: Destructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclSmartcardHandler::~scd_ssc_tclSmartcardHandler()
{
	delete(m_poCCodeMeter);
	delete[]vendor_id;
    delete[]product_id;
    delete[]manufacturer;
    delete[]product;
    delete[]serial;
}

/*************************************************************************************************
* FUNCTION: initialize
* DESCRIPTION: initialize CCodeMeter object
* PARAMETER: scd_ssc_tclProperty *m_poProperty
* RETURNVALUE:  bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclSmartcardHandler::initialize(scd_ssc_tclProperty *m_poProperty,
		                                     scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;
	unsigned int productCode, firmCode;
	scd_ssc_tclUtility  poUtility;
	m_poLogger->log("entering scd_ssc_tclSmartcardHandler -> initialize() ... ");

	/* get all firm and product code from the config file and save it in the property object    */

	if(poUtility.getProductFirmCode(m_poProperty, m_poLogger))
	{
		/* get the first set of product and firm code                                           */
		productCode = m_poProperty->getProductCode();
		firmCode = m_poProperty->getFirmCode();
		/* set them in CCodeMeter object                                                        */
		m_poCCodeMeter->setProductFirmCode(productCode, firmCode);

		while(true)
		{
			/* if they are 0 then stop it                                                       */
			if(productCode == 0 && firmCode == 0)
			{
				status = false;
				m_poLogger->log("scd_ssc_tclSmartcardHandler -> initialize() - failed");
				break;
			}
			else
			{

				std::string product(poUtility.intToString(productCode));
				std::string firm(poUtility.intToString(firmCode));
				m_poLogger->log("authenticating the productCode: " + product + " and the firmCode: "
						         + firm);

				/* otherwise call initialize CCodeMeter member function                         */
				if(m_poCCodeMeter->initialize(m_poLogger) == 0)
				{
					char sn[m_poProperty->getSerialSize()];
					memset(sn, 0, m_poProperty->getSerialSize());
					sprintf((char *)sn,"%010d",m_poCCodeMeter->getSerialNumber());
					m_poProperty->setSerial(sn);

					char ll[m_poProperty->getRequestUnlockLevelSize()];
					memset(ll, 0, m_poProperty->getRequestUnlockLevelSize());
					sprintf((char *)ll,"%d", (productCode % 100));
					m_poProperty->setLockLevel(ll);

					m_poProperty->setPublicKey(((const char *) m_poCCodeMeter->getPublicKey()));
					poUtility.setResponse(m_poProperty, true);
					if(m_poCCodeMeter->sign(((unsigned char*) m_poProperty->getResponseIn()),
							                  m_poProperty->getSignDataSize(), m_poProperty->getSignature(),
							                  m_poLogger) != 0)
					{
						m_poLogger->log("scd_ssc_tclSmartcardHandler -> initialize() -> sign() - failed");
						status = false;
						break;
					}
					poUtility.setResponse(m_poProperty, false);
					status = true;
					break;
				}
			}
			productCode = m_poProperty->getProductCode();
			firmCode = m_poProperty->getFirmCode();
			m_poCCodeMeter->setProductFirmCode(productCode, firmCode);
		}
	}
	else
	{
		status = false;
		m_poLogger->log("scd_ssc_tclSmartcardHandler -> initialize() - failed - getting product and firm code in: "
				        + std::string(m_poProperty->getPathToWibuConfig()));

	}

	m_poLogger->log("exiting scd_ssc_tclSmartcardHandler -> initialize()");

	return status;
}
/*************************************************************************************************
* FUNCTION: getAttributes
* DESCRIPTION: gets the smartcard's attributes
* PARAMETER:
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclSmartcardHandler::getAttributes(void)
{
	bool status = false;
	struct udev *udev;
	struct udev_enumerate *enumerate;
	struct udev_list_entry *devices, *dev_list_entry;
	struct udev_device *dev;

	udev = udev_new();
	if(udev)
	{
		/* Create a list of the devices in the 'hidraw' subsystem.                              */
		enumerate = udev_enumerate_new(udev);
		udev_enumerate_add_match_subsystem(enumerate, "block");
		udev_enumerate_scan_devices(enumerate);
		devices = udev_enumerate_get_list_entry(enumerate);

		/*
	   	   For each item enumerated, print out its information. udev_list_entry_foreach
	   	   is a macro which expands to a loop. The loop will be executed for each member
	   	   in devices, setting dev_list_entry to a list entry
	   	   which contains the device's path in /sys.
		*/
		udev_list_entry_foreach(dev_list_entry, devices)
		{
			const char *path;
			/* Get the filename of the /sys entry for the device
			 and create a udev_device object(dev) representing it                               */
			path = udev_list_entry_get_name(dev_list_entry);
			dev = udev_device_new_from_syspath(udev, path);

			/*
		   	   The device pointed to by dev contains information about the hidraw device.
		   	   In order to get information about the USB device, get the parent device
		   	   with the subsystem/devtype pair of "usb"/"usb_device". This will
		   	   be several levels up the tree, but the function will find it.                    */
			dev = udev_device_get_parent_with_subsystem_devtype(dev, "usb", "usb_device");

			if (!dev)
				continue;
			else
			{
				status = true;
				/*
				   From here, we can call get_sysattr_value() for each file in the
				   device's /sys entry. The strings passed into these
			   	   functions (idProduct, idVendor, serial, etc.) correspond directly to
			   	   the files in the directory which represents
			   	   the USB device. Note that USB strings are Unicode, UCS2 encoded,
			   	   but the strings returned from
			   	   udev_device_get_sysattr_value() are UTF-8 encoded.
				                                                                                */

				setVendorId(udev_device_get_sysattr_value(dev, "idVendor"));
				setProductId(udev_device_get_sysattr_value(dev, "idProduct"));
				setManufacturer(udev_device_get_sysattr_value(dev, "manufacturer"));
				setProduct(udev_device_get_sysattr_value(dev, "product"));
				setSerial( udev_device_get_sysattr_value(dev, "serial"));
				udev_device_unref(dev);
			}
		}
		/* Free the enumerator object */
		udev_enumerate_unref(enumerate);
		udev_unref(udev);
	}
	else
		status = false;

	return status;
}

/*************************************************************************************************
* FUNCTION: getManufacturer
* DESCRIPTION: gets a string - manufacturer
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclSmartcardHandler::getManufacturer() {
	return manufacturer;
}

/*************************************************************************************************
* FUNCTION: setManufacturer
* DESCRIPTION: sets the string - manufacturer
* PARAMETER: const char* man
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclSmartcardHandler::setManufacturer(const char* man) {

	memcpy(manufacturer, man, MANUFACTURER_SIZE);
}

/*************************************************************************************************
* FUNCTION: getProduct
* DESCRIPTION: gets a string - product
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclSmartcardHandler::getProduct() {
	return product;
}

/*************************************************************************************************
* FUNCTION: setProduct
* DESCRIPTION: sets the string - product
* PARAMETER: const char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclSmartcardHandler::setProduct(const char* prod) {
	memcpy(product, prod, PRODUCT_SIZE);
}

/*************************************************************************************************
* FUNCTION: getProductId
* DESCRIPTION: gets a string - product_id
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclSmartcardHandler::getProductId() {
	return product_id;
}

/*************************************************************************************************
* FUNCTION: setProductId
* DESCRIPTION: sets the string - productId
* PARAMETER: const char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclSmartcardHandler::setProductId(const char* product) {

	memcpy(product_id, product, PRODUCT_ID_SIZE);
}

/*************************************************************************************************
* FUNCTION: getSerial
* DESCRIPTION: gets a string - serial
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclSmartcardHandler::getSerial() {
	return serial;
}

/*************************************************************************************************
* FUNCTION: setSerial
* DESCRIPTION: sets the string - serial
* PARAMETER: const char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclSmartcardHandler::setSerial(const char* ser) {

	memcpy(serial, ser, SERIAL_SIZE);
}

/*************************************************************************************************
* FUNCTION: getVendorId
* DESCRIPTION: gets a string - vendor_id
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclSmartcardHandler::getVendorId()  {
	return vendor_id;
}

/*************************************************************************************************
* FUNCTION: setVendorId
* DESCRIPTION: sets the string - vendor_id
* PARAMETER: const char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclSmartcardHandler::setVendorId(const char* vendor) {

	memcpy(vendor_id, vendor, VENDOR_ID_SIZE);
}


