/*************************************************************************************************
 FILE:           scd_ssc_property.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Definition of the property class
                 It stores all relevant data used by other classes/objects

 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#include "scd_ssc_property.h"

/*************************************************************************************************
* FUNCTION: scd_ssc_tclProperty
* DESCRIPTION: Constructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclProperty::scd_ssc_tclProperty():
			ALD_NAME("com.adit.de.ALD"),
			ALD_PATH ("/com/adit/de/ALD/change_level"),
			ALD_INTERFACE_LEVEL_STATUS("com.adit.de.ALD.level_status"),
			ALD_INTERFACE_CHANGE_LEVEL("com.adit.de.ALD.change_level"),
			ALD_SIGNAL_NEW_LEVEL("NewLevel"),
			ALD_SIGNAL_LEVEL_CHANGE_DONE("LevelChangeDone"),
			ALD_METHOD_CHALLENGE("Challenge"), ALD_METHOD_RESPONSE("Response"),
			ALD_METHOD_LOCK_DEVICE("LockDevice"),
			PATH_TO_WIBU_CONFIG_FILE("/etc/security/wibu_smartcard_config.config"),
			CUSTOMER("GM"),
			PYTHON_MODULE("ald_getStatus"),
			PYTHON_CMD_1("import sys"),
			PYTHON_MODULE_CMD_PATH("sys.path.append(\"/opt/bosch/security/bin\")"),
			PYTHON_FUNC("getStatus"),
			MODE_OF_OPERATION("SW_UPDATE_RECOVERY_MODE")



{
	ald_ecu_id_in           = new char[ALD_ECU_ID_SIZE];
	/* old fashion way to initialize an array of characters  :)                                 */
	ald_ecu_id_in[0]        = 't';
	ald_ecu_id_in[1]        = 'e';
	ald_ecu_id_in[2]        = 's';
	ald_ecu_id_in[3]        = 't';
	ald_ecu_id_in[4]        = ' ';
	ald_ecu_id_in[5]        = 'c';
	ald_ecu_id_in[6]        = 'h';
	ald_ecu_id_in[7]        = 'a';
	ald_ecu_id_in[8]        = 'l';
	ald_ecu_id_in[9]        = 'l';
	ald_ecu_id_in[10]       = 'e';
	ald_ecu_id_in[11]       = 'n';
	ald_ecu_id_in[12]       = 'g';
	ald_ecu_id_in[13]       = 'e';
	ald_ecu_id_in[14]       = ' ';
	ald_ecu_id_in[15]       = '\0';

	ald_challenge_out 		= new char[ALD_CHALLENGE_SIZE]();
	response_in 		    = new char[RESPONSE_SIZE]();
	serial                  = new unsigned char[SERIAL_SIZE]();
	lock_level              = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
	public_key              = new unsigned char[PUBLIC_KEY_USER_SIZE]();
	signature               = new unsigned char[SSIGNATURE_SIZE]();
	current_lock_level      = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
	new_lock_level          = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();

	ptr_ecu_id_in           = ald_ecu_id_in;
	ptr_challenge_out 		= ald_challenge_out;
	ptr_response_in         = response_in;
	ald_result_out 			= 0;
	ptr_ald_result_out		= &ald_result_out;
	ald_lock_result_out		= 0;
	ptr_ald_lock_result_out	= &ald_lock_result_out;
}

/*************************************************************************************************
* FUNCTION: scd_ssc_tclProperty
* DESCRIPTION: Copy constructor
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclProperty::scd_ssc_tclProperty(const scd_ssc_tclProperty & oproperty)
{
	ald_ecu_id_in           = new char[ALD_ECU_ID_SIZE]();
	ald_challenge_out 		= new char[ALD_CHALLENGE_SIZE]();
	response_in 		    = new char[RESPONSE_SIZE]();

	serial                  = new unsigned char[SERIAL_SIZE]();
	lock_level              = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
	public_key              = new unsigned char[PUBLIC_KEY_USER_SIZE]();
	signature               = new unsigned char[SSIGNATURE_SIZE]();
	current_lock_level      = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
	new_lock_level          = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();

	ald_ecu_id_in           = oproperty.ald_ecu_id_in;
	ald_challenge_out       = oproperty.ald_challenge_out;
	response_in             = oproperty.response_in;

	serial                  = oproperty.serial;
	lock_level              = oproperty.lock_level;
	public_key              = oproperty.public_key;
	signature               = oproperty.signature;
	current_lock_level      = oproperty.current_lock_level;
	new_lock_level          = oproperty.new_lock_level;

	ptr_ecu_id_in           = oproperty.ald_ecu_id_in;
	ptr_challenge_out 		= oproperty.ald_challenge_out;
	ptr_response_in         = oproperty.response_in;

	ald_result_out 			= 0;
	ptr_ald_result_out		= &ald_result_out;
	ald_lock_result_out		= 0;
	ptr_ald_lock_result_out	= &ald_lock_result_out;
}
/*************************************************************************************************
* FUNCTION: operator=
* DESCRIPTION: Assignment operator
* PARAMETER: scd_ssc_tclProperty &
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclProperty & scd_ssc_tclProperty::operator=(const scd_ssc_tclProperty & oproperty)
{
	if(this == &oproperty)
	{
		return (*this);
	}
	else
	{
		delete[]ald_ecu_id_in;
		delete[]ald_challenge_out;
		delete[]response_in;
		delete[]serial;
		delete[]lock_level;
		delete[]public_key;
		delete[]signature;
		delete[]current_lock_level;
		delete[]new_lock_level;

		ald_ecu_id_in           = new char[ALD_ECU_ID_SIZE]();
		ald_challenge_out 		= new char[ALD_CHALLENGE_SIZE]();
		response_in 		    = new char[RESPONSE_SIZE]();

		serial                  = new unsigned char[SERIAL_SIZE]();
		lock_level              = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
		public_key              = new unsigned char[PUBLIC_KEY_USER_SIZE]();
		signature               = new unsigned char[SSIGNATURE_SIZE]();
		current_lock_level      = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();
		new_lock_level          = new unsigned char[REQUEST_UNLOCK_LEVEL_SIZE]();

		ald_ecu_id_in           = oproperty.ald_ecu_id_in;
		ald_challenge_out       = oproperty.ald_challenge_out;
		response_in             = oproperty.response_in;
		serial                  = oproperty.serial;
		lock_level              = oproperty.lock_level;
		public_key              = oproperty.public_key;
		signature               = oproperty.signature;
		current_lock_level      = oproperty.current_lock_level;
		new_lock_level          = oproperty.new_lock_level;

		ptr_ecu_id_in           = oproperty.ald_ecu_id_in;
		ptr_challenge_out 		= oproperty.ald_challenge_out;
		ptr_response_in         = oproperty.response_in;

		return (*this);
	}
}


/*************************************************************************************************
* FUNCTION: ~scd_ssc_tclProperty
* DESCRIPTION: Destructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclProperty::~scd_ssc_tclProperty()
{
	delete[]ald_ecu_id_in;
	delete[]ald_challenge_out;
	delete[]response_in;
	delete[]serial;
	delete[]lock_level;
	delete[]public_key;
	delete[]signature;
	delete[]current_lock_level;
	delete[]new_lock_level;

	ald_ecu_id_in 	   = NULL;
	ald_challenge_out  = NULL;
	response_in        = NULL;
	serial             = NULL;
	lock_level         = NULL;
	public_key         = NULL;
	signature          = NULL;
	current_lock_level = NULL;
	new_lock_level     = NULL;
}

/*************************************************************************************************
* FUNCTION: getAldChallengeOut
* DESCRIPTION: get a pointer that points to (96 bytes of) data
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclProperty::getAldChallengeOut()const{

	return ptr_challenge_out;
}

/*************************************************************************************************
* FUNCTION: getAldChallengeSize
* DESCRIPTION: gets the challenge size
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getAldChallengeSize() const{
	return ALD_CHALLENGE_SIZE;
}

/*************************************************************************************************
* FUNCTION: getAldEcuIdIn
* DESCRIPTION: gets a string - ald_ecu_id_in
* PARAMETER:
* RETURNVALUE:  char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclProperty::getAldEcuIdIn() const {
	return ald_ecu_id_in;
}

/*************************************************************************************************
* FUNCTION: getAldEcuIdSize
* DESCRIPTION: gets ecu_id size
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getAldEcuIdSize() const{
	return ALD_ECU_ID_SIZE;
}

/*************************************************************************************************
* FUNCTION: getAldEcuIdSize
* DESCRIPTION: gets the size of the data received from ALD
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getResultResponseSize() const{
	return RESULT_RESPONSE_SIZE;
}

/*************************************************************************************************
* FUNCTION: getAldInterfaceChangeLevel
* DESCRIPTION: gets the interface  - ALD_INTERFACE_CHANGE_LEVEL
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldInterfaceChangeLevel() const {
	return ALD_INTERFACE_CHANGE_LEVEL;
}

/*************************************************************************************************
* FUNCTION: getAldInterfaceLevelStatus
* DESCRIPTION: gets the interface - ALD_INTERFACE_LEVEL_STATUS
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldInterfaceLevelStatus() const {
	return ALD_INTERFACE_LEVEL_STATUS;
}

/*************************************************************************************************
* FUNCTION: getAldLockResultOut
* DESCRIPTION: gets the data (result) from ALD after the system is locked
* PARAMETER:
* RETURNVALUE: unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getAldLockResultOut() const {
	return ald_lock_result_out;
}

/*************************************************************************************************
* FUNCTION: getAldMethodChallenge
* DESCRIPTION: gets the interface - ALD_METHOD_CHALLENGE
* PARAMETER:
* RETURNVALUE: const char*
*l
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldMethodChallenge() const {
	return ALD_METHOD_CHALLENGE;
}

/*************************************************************************************************
* FUNCTION: getAldMethodLockDevice
* DESCRIPTION: gets the method - ALD_METHOD_LOCK_DEVICE
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldMethodLockDevice() const {
	return ALD_METHOD_LOCK_DEVICE;
}

/*************************************************************************************************
* FUNCTION: getAldMethodResponse
* DESCRIPTION: gets the method - ALD_METHOD_RESPONSE
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldMethodResponse() const {
	return ALD_METHOD_RESPONSE;
}

/*************************************************************************************************
* FUNCTION: getAldName
* DESCRIPTION:  gets the destination -  ALD_NAME
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldName() const {
	return ALD_NAME;
}

/*************************************************************************************************
* FUNCTION: getAldPath
* DESCRIPTION: gets the ald path - ALD_PATH
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldPath() const {
	return ALD_PATH;
}

/*************************************************************************************************
* FUNCTION: getResponseIn
* DESCRIPTION: gets the data - response
* PARAMETER:
* RETURNVALUE: char*
*
* HISTORY:
*
*
*************************************************************************************************/
char* scd_ssc_tclProperty::getResponseIn() const {
	return response_in;
}

/*************************************************************************************************
* FUNCTION: getResponseSize
* DESCRIPTION: gets the size of the response
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getResponseSize() const {
	return RESPONSE_SIZE;
}

/*************************************************************************************************
* FUNCTION: getAldResultOut
* DESCRIPTION: gets data from ALD
* PARAMETER:
* RETURNVALUE: unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getAldResultOut() const {
	return ald_result_out;
}

/*************************************************************************************************
* FUNCTION: getAldSignalLevelChangeDone
* DESCRIPTION: signal name - ALD_SIGNAL_LEVEL_CHANGE_DONE
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldSignalLevelChangeDone() const {
	return ALD_SIGNAL_LEVEL_CHANGE_DONE;
}

/*************************************************************************************************
* FUNCTION: getAldSignalNewLevel
* DESCRIPTION: signal name - ALD_SIGNAL_NEW_LEVEL
* PARAMETER:l
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getAldSignalNewLevel() const {
	return ALD_SIGNAL_NEW_LEVEL;
}

/*************************************************************************************************
* FUNCTION: getPtrAldEcuId
* DESCRIPTION: pointer to ecu_id
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPtrAldEcuId() const {
	return ptr_ecu_id_in;
}

/*************************************************************************************************
* FUNCTION: getPtrAldResponseInAddress
* DESCRIPTION: gets the address of a pointer that points to response data
* PARAMETER:
* RETURNVALUE: int
*
* HISTORY:
*
*
*************************************************************************************************/
int scd_ssc_tclProperty::getPtrAldResponseInAddress() const {

	int address = (int)&ptr_response_in;
	return address;
}

/*************************************************************************************************
* FUNCTION: getPtrAldLockResultOut
* DESCRIPTION: gets a pointer that points to the result data - lock
* PARAMETER:
* RETURNVALUE: unsigned int*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int* scd_ssc_tclProperty::getPtrAldLockResultOut() const {
	return ptr_ald_lock_result_out;
}

/*************************************************************************************************
* FUNCTION: getPtrAldResultOut
* DESCRIPTION: gets a pointer that points to the result data
* PARAMETER:
* RETURNVALUE: unsigned int*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int* scd_ssc_tclProperty::getPtrAldResultOut() const {
	return ptr_ald_result_out;
}

/*************************************************************************************************
* FUNCTION: getSerialSize
* DESCRIPTION: gets the serial size
* PARAMETER:
* RETURNVALUE:const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const  unsigned int scd_ssc_tclProperty::getSerialSize() const {
	return SERIAL_SIZE;
}

/*************************************************************************************************
* FUNCTION: getRequestUnlockLevelSize
* DESCRIPTION: gets the REQUEST_UNLOCK_LEVEL_SIZE
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const  unsigned int scd_ssc_tclProperty::getRequestUnlockLevelSize() const {
	return REQUEST_UNLOCK_LEVEL_SIZE;
}

/*************************************************************************************************
* FUNCTION: getPublicKeyUserSize
* DESCRIPTION: gets the PUBLIC_KEY_USER_SIZE
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getPublicKeyUserSize() const {
	return PUBLIC_KEY_USER_SIZE;
}

/*************************************************************************************************
* FUNCTION: getReservedSize
* DESCRIPTION: gets the RESERVED_SIZE
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getReservedSize() const {
	return RESERVED_SIZE;
}

/*************************************************************************************************
* FUNCTION: getSignatureSize
* DESCRIPTION: gets the SIGNATURE_SIZE
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const unsigned int scd_ssc_tclProperty::getSignatureSize() const {
	return SSIGNATURE_SIZE;
}

/*************************************************************************************************
* FUNCTION: getSerial
* DESCRIPTION: gets the serial number of a smartcard
* PARAMETER:
* RETURNVALUE: unsigned char*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char* scd_ssc_tclProperty::getSerial() const {
	return serial;
}

/*************************************************************************************************
* FUNCTION: setSerial
* DESCRIPTION: sets the serial number of a smartcard
* PARAMETER: char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::setSerial(const char* ser) const
{
	memset(serial, 0, getSerialSize());
	memcpy(serial, ser, getSerialSize());
}

/*************************************************************************************************
* FUNCTION: getLockLevel
* DESCRIPTION: gets the lock_level
* PARAMETER:
* RETURNVALUE: unsigned char*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char* scd_ssc_tclProperty::getLockLevel() const{
	return lock_level;
}

/*************************************************************************************************
* FUNCTION: setLockLevel
* DESCRIPTION: sets the lock_level
* PARAMETER: const char* lock
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::setLockLevel(const char* lock) const
{
	memset(lock_level, 0, getRequestUnlockLevelSize());
	memcpy(lock_level, lock, getRequestUnlockLevelSize());
}

/*************************************************************************************************
* FUNCTION: getLockLevel
* DESCRIPTION: reads the current lock_level
* PARAMETER:
* RETURNVALUE: unsigned char*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char * scd_ssc_tclProperty::getCurrentLockLevel() {
	return current_lock_level;
}

/*************************************************************************************************
* FUNCTION: setCurrentLockLevel
* DESCRIPTION: sets current lock_level - unconventional way of setting it
*              the string (lock) comes with a single quote so it needs to be removed
* PARAMETER: const char* lock
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::setCurrentLockLevel(const char *level)
{
	memset(current_lock_level, 0, getRequestUnlockLevelSize());
	unsigned int i = 0, y = 0;

	for(i = 0; i < getRequestUnlockLevelSize(); i++ )
	{   /* 39 decimal is a single quota                                                         */
		if((level[i] != 39) && (isdigit(level[i])))
		{
			current_lock_level[y++] = level[i];
		}
	}
	current_lock_level[y] = '\0';
}

/*************************************************************************************************
* FUNCTION: setNewLockLevel
* DESCRIPTION:
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::setNewLockLevel(unsigned char * level)
{

	memset(new_lock_level, 0, getRequestUnlockLevelSize());
	memcpy(new_lock_level, level, getRequestUnlockLevelSize());
}

/*************************************************************************************************
* FUNCTION: getNewLockLevel
* DESCRIPTION:
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char * scd_ssc_tclProperty::getNewLockLevel()
{
	return new_lock_level;
}

/*************************************************************************************************
* FUNCTION: getPublicKey
* DESCRIPTION: gets the public_key
* PARAMETER:
* RETURNVALUE: unsigned char*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char* scd_ssc_tclProperty::getPublicKey() const {
	return public_key;
}

/*************************************************************************************************
* FUNCTION: setPublicKey
* DESCRIPTION: sets the public_key
* PARAMETER: char*
* RETURNVALUE: const char* key
*
* HISTORY:
*l
*
*************************************************************************************************/
void scd_ssc_tclProperty::setPublicKey(const char* key) const
{
	memset(public_key, 0, getPublicKeyUserSize());
	memcpy(public_key, key, getPublicKeyUserSize());
}

/*************************************************************************************************
* FUNCTION: getSignature
* DESCRIPTION: gets the signature
* PARAMETER:
* RETURNVALUE: unsigned char*
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned char* scd_ssc_tclProperty::getSignature() const {
	return signature;
}

/*************************************************************************************************
* FUNCTION: setSignature
* DESCRIPTION: sets the signature
* PARAMETER: const char*
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::setSignature(const char* sig) const
{
	memset(signature, 0, getSignatureSize());
	memcpy(signature, sig, getSignatureSize());
}

/*************************************************************************************************
* FUNCTION: getSignDataSize
* DESCRIPTION: gets the size of the signed data
* PARAMETER:
* RETURNVALUE: unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getSignDataSize(void) const {
	return SIGN_DATA_SIZE;
}

/*************************************************************************************************
* FUNCTION: getEcuPosition
* DESCRIPTION: gets the index of ecu_id position in challenge data
* PARAMETER: unsigned int
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getEcuPosition(void) const {
	return START_ECU_ID_CHALLENGE;
}

/*************************************************************************************************
* FUNCTION: getPathToWibuConfig
* DESCRIPTION: gets the path to  - wibu config file
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPathToWibuConfig(void) const {
	return PATH_TO_WIBU_CONFIG_FILE;
}

/*************************************************************************************************
* FUNCTION: getPathToWibuConfig
* DESCRIPTION: gets the string - CUSTOMER
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getCustomer(void) const {
	return CUSTOMER;
}

/*************************************************************************************************
* FUNCTION: getProductCode
* DESCRIPTION: gets the product code
* PARAMETER:
* RETURNVALUE: unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getProductCode(void)
{
	unsigned int data = 0;

	if(!productcodes.empty())
	{
		data = productcodes.back();
		productcodes.pop_back();
	}

	return data;
}

/*************************************************************************************************
* FUNCTION: getFirmCode
* DESCRIPTION: gets the firm code
* PARAMETER:
* RETURNVALUE: unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
unsigned int scd_ssc_tclProperty::getFirmCode(void)
{
	unsigned int data = 0;

	if(!firmcodes.empty())
	{
		data = firmcodes.back();
		firmcodes.pop_back();
	}

	return data;
}

/*************************************************************************************************
* FUNCTION: getFirmCode
* DESCRIPTION: adds the firm code into a container - vector
* PARAMETER: unsigned int
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::addFirmCode(unsigned int val) {
	firmcodes.push_back(val);
}

/*************************************************************************************************
* FUNCTION: getProductCode
* DESCRIPTION: adds the product code into a container - vector
* PARAMETER: unsigned int
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
void scd_ssc_tclProperty::addProductCode(unsigned int val) {
	productcodes.push_back(val);
}

/*************************************************************************************************
* FUNCTION: getPythonModule
* DESCRIPTION: gets the name of the python module
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPythonModule(void) const {
	return PYTHON_MODULE;
}

/*************************************************************************************************
* FUNCTION: getPythonCmd1
* DESCRIPTION: gets the python execution command
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPythonCmd1(void) const {
	return PYTHON_CMD_1;
}

/*************************************************************************************************
* FUNCTION: getPythonModuleCmdPath
* DESCRIPTION: gets the command plus path to the python module
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPythonModuleCmdPath(void) const {
	return PYTHON_MODULE_CMD_PATH;
}

/*************************************************************************************************
* FUNCTION: getPythonFunc
* DESCRIPTION: gets the python's module function name
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getPythonFunc(void) const {
	return PYTHON_FUNC;
}

/*************************************************************************************************
* FUNCTION: getModeOfOperation
* DESCRIPTION: gets the env key
* PARAMETER:
* RETURNVALUE: const char*
*
* HISTORY:
*
*
*************************************************************************************************/
const char* scd_ssc_tclProperty::getModeOfOperation(void)const {
	return MODE_OF_OPERATION;
}

/*************************************************************************************************
* FUNCTION: getLockedLevel
* DESCRIPTION: gets the locked level - 0
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const int scd_ssc_tclProperty::getLockedLevel(void) const {
	return LOCKED_LEVEL;
}


/*************************************************************************************************
* FUNCTION: getMaxUnlockedLevel
* DESCRIPTION: gets the maximum unlocked level - 50
* PARAMETER:
* RETURNVALUE: const unsigned int
*
* HISTORY:
*
*
*************************************************************************************************/
const int scd_ssc_tclProperty::getMaxUnlockedLevel(void) const {
	return MAX_UNLOCKED_LEVEL;
}










