/*************************************************************************************************
 FILE:           scd_ssc_clienthandler_ALD.cpp
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    Definition of the ALD client class
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version - class definition

 ************************************************************************************************/
#include "scd_ssc_clienthandler_ALD.h"

/*************************************************************************************************
* FUNCTION: scd_ssc_tclClientHandler_ALD
* DESCRIPTION: constructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclClientHandler_ALD::scd_ssc_tclClientHandler_ALD():
			m_ptrConnection(NULL), reply(NULL), msg(NULL)
{
}

/*************************************************************************************************
* FUNCTION: scd_ssc_tclClientHandler_ALD
* DESCRIPTION: copy constructor - not finished
* PARAMETER:l
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclClientHandler_ALD::scd_ssc_tclClientHandler_ALD(const scd_ssc_tclClientHandler_ALD & oscd_ssc)
{

}
/*************************************************************************************************
* FUNCTION: operator=
* DESCRIPTION: assignment operator - not finished
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclClientHandler_ALD & scd_ssc_tclClientHandler_ALD::operator=(const scd_ssc_tclClientHandler_ALD & oscd_ssc)
{
	return (*this);
}

/*************************************************************************************************
* FUNCTION: ~scd_ssc_tclClientHandler_ALD
* DESCRIPTION: Destructor
* PARAMETER:
* RETURNVALUE:
*
* HISTORY:
*
*
*************************************************************************************************/
scd_ssc_tclClientHandler_ALD::~scd_ssc_tclClientHandler_ALD()
{
}

/*************************************************************************************************
* FUNCTION: challenge
* DESCRIPTION: gets data from ALD (96 bytes)
* PARAMETER: a pointer to scd_ssc_tclProperty
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::challenge(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger)
{
	bool status = false;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> challenge() ... ");

	if(sendArgAndReply(0,										  /* challenge 		            */
					   ald_property->getAldName(),		          /* ALD_NAME 					*/
			 	 	   ald_property->getAldPath(),                /* ALD_PATH 					*/
					   ald_property->getAldInterfaceChangeLevel(),/* ALD_INTERFACE_CHANGE_LEVEL */
					   ald_property->getAldMethodChallenge(),	  /* ALD_METHOD_CHALLENGE 		*/
					   ald_property->getAldEcuIdIn(),			  /* ALD_ECU_ID_IN 				*/
					   ald_property->getAldChallengeOut(),		  /* ald_challenge_out 			*/
					   0,										  /* 0 							*/
					   ald_property->getAldEcuIdSize(),			  /* ALD_ECU_ID_SIZE 			*/
					   ald_property->getAldChallengeSize(),	      /* ALD_CHALLENGE_SIZE 		*/
		               m_poLogger))
	{
		/* test the data received from ALD                                                      */
		scd_ssc_tclUtility utility;
		if(utility.isChallenge(ald_property))
			status = true;
		else
		{
			status = false;
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> challenge() -> isChallenge() - failed - "
					        "ecu id and ecu id in challenge do not match ");
		}
	}
	else
	{
		status = false;
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> challenge() -> sendArgAndReply() - failed");
	}
	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> challenge()");

	return status;
}

/*************************************************************************************************
* FUNCTION: response
* DESCRIPTION: sends 1400 bytes of data to ALD
* PARAMETER: a pointer to scd_ssc_tclProperty
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY: initial version and final version
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::response(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> response() ... ");

	if(sendArgAndReply(1, 								          /* response 		            */
					   ald_property->getAldName(),				  /* ALD_NAME 			        */
	 	 	   	   	   ald_property->getAldPath(),                /* ALD_PATH 					*/
	 	 	   	   	   ald_property->getAldInterfaceChangeLevel(),/* ALD_INTERFACE_CHANGE_LEVEL */
					   ald_property->getAldMethodResponse(),	  /* ALD_METHOD_RESPONSE 		*/
					   ald_property->getResponseIn(),		      /* ptr_ald_response_in 		*/
					   0,			                              /* 0 							*/
					   ald_property->getPtrAldResultOut(),		  /* ptr_ald_result_out 		*/
					   ald_property->getResponseSize(),		      /* ALD_RESPONSE_SIZE 			*/
					   ald_property->getResultResponseSize(),	  /* RESULT_RESPONSE_SIZE 		*/
		               m_poLogger))
	{
		/* test the data received from ALD                                                      */
		scd_ssc_tclUtility utility;
		/* check if the error message is returned                                         	    */
		if(utility.isResponse(ald_property))
		{
			if(!utility.getMode(ald_property)) /* do not run the below if we are in DLinitRAMFS */
			{
				/* now check if we have unlocked the device                                     */
				(void)getStatus(ald_property,  m_poLogger);
				/* comparing lock level that we got from the smartcard to the current lock level*/
				//int smartcard_level = atoi((char*)ald_property->getLockLevel());
				//int current = atoi((char*)ald_property->getCurrentLockLevel());

				//if(smartcard_level == current)
				if(strcmp(((const char*)ald_property->getLockLevel()),
						  ((const char*)ald_property->getCurrentLockLevel())) == 0)
				{
					status = true;
					ald_property->setNewLockLevel(ald_property->getLockLevel());
				}
				else
				{
					status = false;
					m_poLogger->log("scd_ssc_tclClientHandler_ALD -> response() - failed - "
												"lock level is not right");
				}
			}
		}
		else
		{
			status = false;
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> response() -> isResponse() - failed - "
					        "error is generated by ALD");
		}
	}
	else
	{
		status = false;
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> response() -> sendArgAndReply() - failed");

	}
	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> response()");

	return status;
}

/*************************************************************************************************
* FUNCTION: lockDevice
* DESCRIPTION: locks the device
* PARAMETER: a pointer to scd_ssc_tclProperty
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY: initial version and final version - not tested
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::lockDevice(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger)
{
	bool status = false;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> lockDevice() ... ");

	if(sendAndReply(ald_property->getAldName(),		              /* ALD_NAME 			        */
	   	   	        ald_property->getAldPath(),                   /* ALD_PATH 					*/
	   	   	        ald_property->getAldInterfaceChangeLevel(),	  /* ALD_INTERFACE_CHANGE_LEVEL */
			        ald_property->getAldMethodLockDevice(),	  	  /* ALD_METHOD_LOCK_DEVICE     */
			        ald_property->getPtrAldLockResultOut(),	      /* ald_lock_result_out 		*/
		            m_poLogger))
	{
		/* get the current level and compare it with 0                                          */
		(void)getStatus(ald_property,  m_poLogger);
		int current = atoi((char*)ald_property->getCurrentLockLevel());
		int locked =  ald_property->getLockedLevel();

		if(current == locked)
		{
			status = true;
			scd_ssc_tclUtility utility;
			ald_property->setNewLockLevel((unsigned char*)utility.intToString(ald_property->getLockedLevel()));
		}
		else
		{
			status = false;
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> lockDevice()  - failed ");
		}
	}
	else
	{
		status = false;
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> lockDevice() -> senAndReply() - failed");
	}
	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> lockDevice()");

	return status;
}

/*************************************************************************************************
* FUNCTION: getStatus
* DESCRIPTION: gets the current unlock/lock level
* PARAMETER: scd_ssc_tclProperty
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::getStatus(scd_ssc_tclProperty *ald_property,
		                                     scd_ssc_tclLogger  *m_poLogger)
{
	bool status = false;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> getStatus() ... ");

	/*                           FORK/EXECLP IMPLEMENTATION START (IT WORKS)                    */
	/*
	int s_flag, d_flag;
	const char *script_path = "/opt/bosch/security/bin/ald_getStatus1.py";
	const char *tool = "python";
	const char *tool_location = "python";

	int pid = fork();

	if(pid == 0)
	{
		int err = execlp(tool_location, tool, script_path ,(char*) NULL);
		std::cout << "Error: in execlp call: "<< err << std::endl;
		status = false;
	}
	else if(pid < 0)
	{
		std::cout << "\ngetStatus: Failed to fork" << std::endl;
		status = false;
	}
	else
	{
		d_flag = wait(&s_flag);
	}
    */
	/*                                 FORK/EXECLP IMPLEMENTATION END                           */

    /*                              EMBEDDED PYTHON IMPLEMENTATION START                        */

	Py_Initialize();
	PyObject *pName, *pModule, *pDict, *pFun, *pValue;
	pName = PyString_FromString(ald_property->getPythonModule());
	PyRun_SimpleString(ald_property->getPythonCmd1());
	PyRun_SimpleString(ald_property->getPythonModuleCmdPath());

	pModule = PyImport_Import(pName);
	if(pModule != NULL)
	{
		pDict = PyModule_GetDict(pModule);
		if(pDict != NULL)
		{
			pFun = PyDict_GetItemString(pDict, ald_property->getPythonFunc());
			if(pFun != NULL)
			{
				if (PyCallable_Check(pFun))
				{
					pValue = PyObject_CallObject(pFun, NULL);
					PyObject* objectsRepresentation = PyObject_Repr(pValue);
					const char* s = PyString_AsString(objectsRepresentation);
					ald_property->setCurrentLockLevel(s);
					status = true;

				}else { PyErr_Print();}
			}else { PyErr_Print();}
		}else { PyErr_Print();}
	}else { PyErr_Print();}

	Py_DECREF(pModule);
	Py_DECREF(pName);

	Py_Finalize();

	/*                            EMBEDDED PYTHON IMPLEMENTATION END                            */

	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> getStatus()");

	return status;
}

/*************************************************************************************************
* FUNCTION: sendArgAndReply
* DESCRIPTION: sends args and reads the return value
* PARAMETER: unsigned int op, const char *name, const char *path, const char *iface,
*            const char *method, char *in, char *out, unsigned int *int_out,
			 const unsigned int in_size, const unsigned int out_size
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::sendArgAndReply(unsigned int op, const char *name,
		                           const char *path, const char *iface, const char *method,
								   char *in, char *out, unsigned int *int_out,
								   const unsigned int in_size, const unsigned int out_size,
								   scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> sendArgAndReply() ...");

	if(initConnection(m_poLogger))
	{
		/*
		   Construct a new message to invoke a method on a remote object - ALD
		   arguments:
		   1 - name that the message should be sent to
		   2 - object path the message should be sent to
		   3 - interface to invoke method on
		   4 - method to invoke
																								*/
		msg = dbus_message_new_method_call(name, path, iface, method);

		if(msg == NULL)
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed "
					        "memory can not be allocated");
			exit(1);
		}
		/* Appends fields to a message given a variable argument list							*/
		if (!dbus_message_append_args(msg, DBUS_TYPE_ARRAY, DBUS_TYPE_BYTE, &in,
				in_size, DBUS_TYPE_INVALID))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed - "
							"run out of memory while constructing args");
			exit(1);
		}

		/* send the message 																	*/
		if (!dbus_connection_send_with_reply(m_ptrConnection, msg, &pending, -1))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed - "
							"failed to send a message" );
			exit(1);
		}
		/* flush it	                                                                            */
		dbus_connection_flush(m_ptrConnection);
		/* unref it                                                                       		*/
		dbus_message_unref(msg);
		/* block until the pending call is completed                                            */
		dbus_pending_call_block(pending);
		/* gets the reply, or returns NULL if none has been received yet                        */
		msg = dbus_pending_call_steal_reply(pending);
		/* decrements the reference count on a pending call										*/
		dbus_pending_call_unref(pending);

		/* initializes a DBusMessageIter for reading the arguments of the message passed in     */
		if (!dbus_message_iter_init(msg, &iter))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed - "
							"message has no arguments");
			status = false;
		}

		if((op == 0) && DBUS_TYPE_ARRAY != dbus_message_iter_get_arg_type(&iter))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed - "
							"wrong argument op = 0");
			status = false;
		}
		else if((op == 1) && DBUS_TYPE_INT32 != dbus_message_iter_get_arg_type(&iter))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - failed - "
							"wrong argument op = 1");
			status = false;
		}
		else
		{
			if(op == 0)
			{
				dbus_message_iter_recurse(&iter, &subiter);
				while(dbus_message_iter_has_next(&subiter))
				{
					dbus_message_iter_get_basic(&subiter, out++);
					dbus_message_iter_next (&subiter);
				}
			}
			else
			{
				dbus_message_iter_get_basic(&iter, &int_out);
			}
		}
		dbus_connection_flush(m_ptrConnection);
	}
	else
	{
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendArgAndReply() - "
						"creating a connection for the method - " + std::string(method) + " - failed");
		status = false;
	}

	dbus_message_unref(msg);
	dbus_connection_unref(m_ptrConnection);
	m_ptrConnection = NULL;
	msg = NULL;

	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> sendArgAndReply()");


	return status;
}

/*************************************************************************************************
* FUNCTION: sendAndReply
* DESCRIPTION: sends no arg and reads the return data
* PARAMETER: const char *name, const char *path,
		     const char *iface, const char *method, unsigned int *result_out
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool scd_ssc_tclClientHandler_ALD::sendAndReply(const char *name, const char *path,
		                          const char *iface, const char *method, unsigned int *result_out,
		                          scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;
	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> sendAndReply() ...");

	if(initConnection(m_poLogger))
	{
		/*
		   Construct a new message to invoke a method in ALD
		   arguments:
		   1 - name that the message should be sent to
		   2 - object path the message should be sent to
		   3 - interface to invoke method on
		   4 - method to invoke
																							    */
		msg = dbus_message_new_method_call(name, path, iface, method);
		if(msg == NULL)
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendAndReply() - failed - "
					        "memory can not be allocated");
			exit(1);
		}

		if (!dbus_connection_send_with_reply(m_ptrConnection, msg, &pending, -1))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendAndReply() - failed - "
						    "failed to send a message");
			exit(1);
		}

		/* flush it	                                                                            */
		dbus_connection_flush(m_ptrConnection);
		/* unref it                                                                       		*/
		dbus_message_unref(msg);
		/* block until the pending call is completed                                            */
		dbus_pending_call_block(pending);
		/* gets the reply, or returns NULL if none has been received yet                        */
		msg = dbus_pending_call_steal_reply(pending);
		dbus_pending_call_unref(pending);
		/* gets the type of a message and is it an error message                                */
		if(dbus_message_get_type(reply) ==  DBUS_MESSAGE_TYPE_ERROR)
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendAndReply() - failed - " +
						   std::string(dbus_message_get_error_name(reply)));
			reply = NULL;
			status = false;
		}
		if(reply != NULL)
		{
			/* initializes a DBusMessageIter for reading the arguments of the message passed in */
			dbus_message_iter_init(reply, &iter);
			if (DBUS_TYPE_INT32 == dbus_message_iter_get_arg_type(&iter))
			{
				dbus_message_iter_get_basic(&iter, &result_out);
			}
			dbus_message_unref(msg);
		}
	}
	else
	{
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendAndReply() - "
						"creating a connection for the method - " + std::string(method) + " - failed");
		status = false;
	}
	dbus_connection_unref(m_ptrConnection);
	m_ptrConnection = NULL;

	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> sendAndReply()");

	return status;
}


/*************************************************************************************************
* FUNCTION: sendSignal()
* DESCRIPTION: sends a signal
* PARAMETER:
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool  scd_ssc_tclClientHandler_ALD::sendSignal(const char *name, const char *path,
		                                       const char *iface, const char *signal,
		                                       scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;
	int ret = 0;
	dbus_uint32_t serial = 0;

	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> sendSignal() ...");


	if(initConnection(m_poLogger))
	{
		msg = dbus_message_new_signal(path,iface, signal);
		if (msg == NULL)
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendSignal() - failed - "
					        "message error");

			exit(1);
		}
		dbus_message_iter_init_append(msg, &iter);
		if(!dbus_message_iter_append_basic(&iter, DBUS_TYPE_STRING, &signal))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendSignal() - failed - "
						    "out of memory ");
			exit(1);
		}
		if(!dbus_connection_send(m_ptrConnection, msg, &serial))
		{
			m_poLogger->log("scd_ssc_tclClientHandler_ALD -> sendSignal() - failed - "
						    "out of memory ");
			exit(1);
		}
		dbus_connection_flush(m_ptrConnection);
		dbus_message_unref(msg);
	}

	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> sendSignal()");

	return status;
}

/*************************************************************************************************
* FUNCTION: initConnection()
* DESCRIPTION: makes a D-Bus connection
* PARAMETER:
* RETURNVALUE: bool, true - success, false - failed
*
* HISTORY:
*
*
*************************************************************************************************/
bool  scd_ssc_tclClientHandler_ALD::initConnection(scd_ssc_tclLogger  *m_poLogger)
{
	bool status = true;

	m_poLogger->log("entering scd_ssc_tclClientHandler_ALD -> initConnection() ...");
	/* init d-bus error                                                                         */
	dbus_error_init(&error);
	/* connect to the system bus and check for errors                                           */
	/* The login system bus type and error are arguments										*/
	m_ptrConnection = dbus_bus_get(DBUS_BUS_SYSTEM, &error);
	/* test for error																			*/
	if(dbus_error_is_set(&error))
	{
		/* for debugging purpose show it on serial terminal										*/
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> initConnection() - failed - " +
				std::string(error.message));
		/* if error then free it																*/
		dbus_error_free(&error);
		/* update status flag																	*/
		status  = false;
	}
	/* if a new connection is not created or doesn't exist										*/
	if(m_ptrConnection == NULL)
	{
		/* safely exit the application															*/
		m_poLogger->log("scd_ssc_tclClientHandler_ALD -> initConnection() - failed - "
						"connection is NULL");
		exit(1);
	}

	m_poLogger->log("exiting scd_ssc_tclClientHandler_ALD -> initConnection()");

	return status;
}

