/* ---------------------------------------------------------------------------
 * CodeMeter Compact Driver
 *
 * Copyright (C) 2002-2015 by WIBU-SYSTEMS AG
 * Rueppurrer Strasse 52-54, D-76137 Karlsruhe, Germany/Europe
 * Website: http://www.wibu.com, Email: info@wibu.com
 * Phone: +49-721-93172-0, Fax: +49-721-93172-22
 * All rights reserved.
 * 
 *
 * This file is a part of the CodeMeter Compact Driver.
 *
 * Disclaimer: IMPORTANT:  This software is supplied to you by 
 * WIBU-SYSTEMS AG in consideration of your agreement to the 
 * following terms, and your use, installation, modification 
 * or redistribution of this software constitutes acceptance of 
 * these terms. If you do not agree with these terms, please do 
 * not use, install, modify or redistribute this software.
 *
 * The contents of the CodeMeter Compact Driver (called library) is 
 * published under non-disclosure agreement (NDA) and are subject 
 * to the Wibu-System license. 
 * 
 * ---------------------------------------------------------------------------
 */


#if !defined(_CODEMETER_INCLUDED)
#define _CODEMETER_INCLUDED



#define CODEMETER_VERSION 431
#define CODEMETER_EMBEDDED 100

#if defined(__cplusplus)

extern "C" {
#endif

#if !defined(CMAPIENTRY)
  #if defined(_WIN32)

    #define CMAPIENTRY __cdecl
  #else

    #define CMAPIENTRY
  #endif
#endif

#if !defined(CODEMETER_API)
  #if (defined(_WIN32) || defined(_WIN32_WCE)) && !defined(_CODEMETER_API_STATIC_LIB)

    #if defined(_CODEMETER_API_EXPORTS)

      #define CODEMETER_API __declspec(dllexport)
    #else

      #define CODEMETER_API __declspec(dllimport)
    #endif
  #else

    #define CODEMETER_API
  #endif
#endif

#if defined(_WIN32)
  #define CMUINT     unsigned int
  #define CMULONG    unsigned long
  #define CMUSHORT   unsigned short
  #define CMBYTE     unsigned char
#elif defined(_WIN64)
  #define CMUINT     unsigned int
  #define CMULONG    unsigned long
  #define CMUSHORT   unsigned short
  #define CMBYTE     unsigned char
#elif defined(__linux__) || (defined(__vxworks__) || defined(__vxworks))
  #define CMUINT     unsigned int
  #define CMULONG    unsigned int
  #define CMUSHORT   unsigned short
  #define CMBYTE     unsigned char
#else
  #define CMUINT     unsigned int
  #define CMULONG    unsigned long
  #define CMUSHORT   unsigned short
  #define CMBYTE     unsigned char
#endif





#define CMERROR_NO_ERROR                        0

#define CMERROR_COMMANDUNDEFINED                1
#define CMERROR_COMMANDINVALID                  2
#define CMERROR_COMMANDTOOLARGE                 3
#define CMERROR_COMMANDWRONG                    4
#define CMERROR_COMMANDTVBWRONG                 5
#define CMERROR_COMMANDINCOMPLETE               6
#define CMERROR_AWAITENCRYPTIONRESTART          7
#define CMERROR_ANSWERBUFFERFULL                8
#define CMERROR_VALUETOOLARGE                   9
#define CMERROR_OPTIONUNDEFINED                 10
#define CMERROR_OPTIONINVALID                   11
#define CMERROR_TYPEUNDEFINED                   12
#define CMERROR_TYPEWRONG                       13
#define CMERROR_KEYSOURCEUNDEFINED              14
#define CMERROR_KEYSOURCEINVALID                15
#define CMERROR_KEYSOURCEMISSED                 16
#define CMERROR_KEYSOURCEWRONG                  17
#define CMERROR_DATATOOSHORT                    18
#define CMERROR_DATATOOLONG                     19
#define CMERROR_DATAWRONG                       20
#define CMERROR_FIRMITEMINVALID                 21
#define CMERROR_FIRMCODEEXISTS                  22
#define CMERROR_PRODUCTITEMINVALID              23
#define CMERROR_PRODUCTITEMOPTIONUNDEFINED      24
#define CMERROR_PRODUCTITEMOPTIONINVALID        25
#define CMERROR_PRODUCTITEMOPTIONMISSED         26
#define CMERROR_FIRMCODEWRONG                   27
#define CMERROR_PRODUCTCODEWRONG                28
#define CMERROR_FEATUREMAPMISSED                29
#define CMERROR_FEATUREMAPINCOMPATIBLE          30
#define CMERROR_UNITCOUNTERMISSED               31
#define CMERROR_UNITCOUNTERZERO                 32
#define CMERROR_UNITCOUNTERUNDERRUN             33
#define CMERROR_EXPIRATIONTIMEMISSED            34
#define CMERROR_EXPIRATIONTIMEOVERRUN           35
#define CMERROR_ACTIVATIONTIMEMISSED            36
#define CMERROR_ACTIVATIONTIMEUNDERRUN          37
#define CMERROR_FIRMACCESSCOUNTERZERO           38
#define CMERROR_CERTIFIEDTIMEOBSOLETE           39
#define CMERROR_ENCRYPTIONINVALID               40
#define CMERROR_DIFFIEHELLMANFAILED             41
#define CMERROR_ECIESFAILED                     42
#define CMERROR_SUBCOMMANDUNDEFINED             43
#define CMERROR_SUBCOMMANDINVALID               44
#define CMERROR_SUBCOMMANDINCOMPLETE            45
#define CMERROR_SUBCOMMANDSTRUCTUREWRONG        46
#define CMERROR_TVBWRONG                        47
#define CMERROR_FIRMUPDATECOUNTERWRONG          48
#define CMERROR_PITVBFLAGINVALID                49
#define CMERROR_PITVBFLAGINCOMPATIBLE           50
#define CMERROR_ENABLEBLOCKUSED                 51
#define CMERROR_BOXDISABLED                     52
#define CMERROR_FIRMITEMDISABLED                53
#define CMERROR_PRODUCTITEMDISABLED             54
#define CMERROR_INDEXINVALID                    55
#define CMERROR_LEVELINVALID                    56
#define CMERROR_TABLEFULL                       57
#define CMERROR_MEMORYFULL                      58
#define CMERROR_MEMORYDAMAGED                   59
#define CMERROR_QUEENMEMORYDAMAGED              60
#define CMERROR_FIRMITEMDAMAGED                 61
#define CMERROR_CRTOKENOBSOLETE                 62
#define CMERROR_MEMORYWRITEFAILED               63
#define CMERROR_BOXBUSY                         64
#define CMERROR_FEATURECODEINVALID              65
#define CMERROR_COMMANDUNSUPPORTED              66
#define CMERROR_FIELDUPDATELIMITEXCEEDED        67
#define CMERROR_FLASHWRITEFAILED                68
#define CMERROR_ACCESSMODEWRONG                 69
#define CMERROR_BOXLOST                         70
#define CMERROR_USAGEPERIODOVERRUN              71
#define CMERROR_USAGEPERIODUNDERRUN             72
#define CMERROR_BOXLOCKED                       73
#define CMERROR_BOX_DAMAGED                     74
#define CMERROR_BOX_LOCKED_TO                   75
#define CMERROR_MAINTENANCEPERIODMISSING        76
#define CMERROR_MAINTENANCEPERIODUNDERRUN       77
#define CMERROR_MAINTENANCEPERIODOVERRUN        78
#define CMERROR_MAINTENANCEPERIODINVALID        79

#define CMERROR_BOXMEMORYDAMAGED                80
#define CMERROR_BOSSMEMORY_DAMAGED              81
#define CMERROR_FIRMWAREMEMORY_DAMAGED          82
#define CMERROR_BOSS_FIRMWAREMEMORY_DAMAGED     83
#define CMERROR_FUMMEMORY_DAMAGED               84
#define CMERROR_BOSS_FUMMEMORY_DAMAGED          85
#define CMERROR_FIRMWARE_FUMMEMORY_DAMAGED      86
#define CMERROR_BOSS_FIRMWARE_FUMMEMORY_DAMAGED 87
#define CMERROR_SYSTIMEOBSOLETE                 88
#define CMERROR_BAD_IO_MODE                     89
#define CMERROR_FULA_UPDATEEB_REACHED           90
#define CMERROR_FULA_ENCRCOMM_REACHED           91
#define CMERROR_UNFRAMED_COMMAND_REJECTED       92
#define CMERROR_COMMAND_PARTIALLY_REJECTED      93
#define CMERROR_COMMAND_PARTIALLY_UNSUPPORTED   94


#define CMERROR_NETWORK_FAULT                   100
#define CMERROR_SERVER_NOT_FOUND                101
#define CMERROR_SEND_FAULT                      102
#define CMERROR_RECEIVE_FAULT                   103
#define CMERROR_INTERNAL_ORGANISATION           104
#define CMERROR_INVALID_PARAMETER               105
#define CMERROR_INVALID_HANDLE                  106
#define CMERROR_NO_MORE_HANDLES                 107
#define CMERROR_NO_MORE_MEMORY                  108
#define CMERROR_SECURITY_PROBLEM                109
#define CMERROR_NO_LOCAL_SERVER_STARTED         110
#define CMERROR_NO_NETWORK_SERVER               111
#define CMERROR_BUFFER_OVERFLOW                 112
#define CMERROR_BAD_ADDRESS                     113
#define CMERROR_BAD_HANDLE                      114
#define CMERROR_WRONG_HANDLE_TYPE               115
#define CMERROR_UNDEFINED_SYSTEM_HANDLE         116
#define CMERROR_NO_EVENT_OCCURRED               117
#define CMERROR_CTCS_FAULT                      118
#define CMERROR_UNKNOWN_OS                      119
#define CMERROR_NO_SECURITY_OBJECT              120
#define CMERROR_WRONG_SECURITY_OBJECT           121
#define CMERROR_NO_FSB_FUNCTIONALITY            122
#define CMERROR_NO_CTSB_FUNCTIONALITY           123
#define CMERROR_WRONG_OEMID                     124
#define CMERROR_SERVER_VERSION_TOO_OLD          125

#define CMERROR_LIBRARY_NOT_FOUND               126


#define CMERROR_BOX_COMMUNICATION_176           176
#define CMERROR_BOX_COMMUNICATION_177           177
#define CMERROR_BOX_COMMUNICATION_178           178
#define CMERROR_BOX_COMMUNICATION_179           179
#define CMERROR_BOX_COMMUNICATION_180           180
#define CMERROR_BOX_COMMUNICATION_181           181
#define CMERROR_BOX_COMMUNICATION_182           182
#define CMERROR_BOX_COMMUNICATION_183           183
#define CMERROR_BOX_COMMUNICATION_184           184
#define CMERROR_BOX_COMMUNICATION_185           185
#define CMERROR_BOX_COMMUNICATION_186           186
#define CMERROR_BOX_COMMUNICATION_187           187
#define CMERROR_BOX_COMMUNICATION_188           188
#define CMERROR_BOX_COMMUNICATION_189           189
#define CMERROR_BOX_COMMUNICATION_190           190
#define CMERROR_BOX_COMMUNICATION_191           191


#define CMERROR_I2C_TIMEOUT_REQUEST             192
#define CMERROR_I2C_TIMEOUT_ANSWER              193
#define CMERROR_I2C_ANSWER_CRC                  194
#define CMERROR_I2C_TWCOMMAND_INVALID           195
#define CMERROR_I2C_PROTOCOL_VERSION            196 
#define CMERROR_I2C_COMMUNICATION               197 
#define CMERROR_I2C_REQUEST_CRC                 198 
#define CMERROR_I2C_ANSWER_BEFORE_REQUEST       199 


#define CMERROR_ENTRY_NOT_FOUND                 200
#define CMERROR_BOX_NOT_FOUND                   201
#define CMERROR_CRYPTION_FAILED                 202
#define CMERROR_CRC_VERIFY_FAILED               203
#define CMERROR_NO_ENABLING_EXISTS              204
#define CMERROR_NO_PIO_SET                      205
#define CMERROR_FIRMKEY_TOO_SHORT               206
#define CMERROR_NO_BOXLOCK_NEEDED               207
#define CMERROR_BOXLOCK_NOT_CHANGED             208
#define CMERROR_NO_DATA_AVAILABLE               209
#define CMERROR_SIGNEDLIST_FAILED               210
#define CMERROR_VALIDATION_FAILED               211
#define CMERROR_NO_MORE_LICENSES                212
#define CMERROR_EXCLUSIVE_MODE_CONFLICT         213
#define CMERROR_RESERVEDFI_MISSED               214
#define CMERROR_WRONG_CONTENT                   215
#define CMERROR_FIELDUPDATE_FAILED              216
#define CMERROR_LICENSEFILE_CREATION_FAILED     217
#define CMERROR_NO_LICENSE_AVAILABLE            218
#define CMERROR_CONTEXT_FILE_WRITING_FAILED     219
#define CMERROR_UPDATE_FILE_READING_FAILED      220
#define CMERROR_NETINFO_FAILED                  221
#define CMERROR_FIELDUPDATE_RESET_FAILED        222
#define CMERROR_WRONG_ACCESS_MODE               223
#define CMERROR_WRONG_BOX_VERSION               224
#define CMERROR_INVALID_LICENSE_PARAMETER       225
#define CMERROR_BORROW_LICENSE_FAILED           226
#define CMERROR_BORROW_LICENSE_ISENABLED        227
#define CMERROR_UPDATE_TOO_NEW                  228
#define CMERROR_UPDATE_TOO_OLD                  229
#define CMERROR_SEVERAL_REASONS                 230
#define CMERROR_ACCESS_DENIED                   231
#define CMERROR_BORROW_TIMEDIFFTOOLARGE         232
#define CMERROR_UPDATE_FAILED                   233
#define CMERROR_UPDATE_ABORTED                  234
#define CMERROR_COMMAND_PENDING                 235
#define CMERROR_REMOTE_ACCESS_DENIED            239
#define CMERROR_INTERNAL                        254
#define CMERROR_UNKNOWN                         255


#define CMERROR_CMACT_SUBSYSTEM_FAILED              260
#define CMERROR_CMACT_LICENSE_NOT_ACTIVATED         261
#define CMERROR_CMACT_LICENSE_ALREADY_ACTIVATED     262
#define CMERROR_CMACT_LICENSE_REACTIVATION_REQUIRED 263
#define CMERROR_CMACT_LICENSE_INVALID               264
#define CMERROR_CMACT_COMMAND_NOT_SUPPORTED         265
#define CMERROR_CMACT_LICENSE_ALREADY_EXISTS        266
#define CMERROR_CMACT_RUN_AS_SERVICE_REQUIRED       267
#define CMERROR_CMACT_BINDING_NOT_POSSIBLE          268
#define CMERROR_CMACT_OPEN_FIRMITEM_TEMPLATE_FAILED 269
#define CMERROR_CMACT_OSVERSION_NOT_PERMITTED       270
#define CMERROR_CMACT_HOST_ID_NOT_AVAILABLE         271
#define CMERROR_CMACT_PLUGIN_MALFUNCTION            272
#define CMERROR_CMACT_VIRTUAL_MACHINE_NOT_ALLOWED   273
#define CMERROR_INCOMPATIBLE_SYSTEM_SOFTWARE_FOUND  274


#define CMERROR_ERRORTEXT_NOT_FOUND             300
#define CMERROR_SEND_PROTECTION_FAILED          301
#define CMERROR_ANALYSING_DETECTED              302
#define CMERROR_COMMAND_EXECUTION_FAILED        303
#define CMERROR_FUNCTION_NOT_IMPLEMENTED        304
#define CMERROR_OBSOLETE_FUNCTION               305
#define CMERROR_FUNCTION_NOT_SUPPORTED          306
#define CMERROR_VERIFY_FAILED                   308



#define CM_CHALLENGE_LEN              16
#define CM_BLOCK_SIZE                 16
#define CM_BLOCKCIPHER_KEY_LEN        32
#define CM_DIGEST_LEN                 32
#define CM_IP_ADDRESS_LEN             8
#define CM_PRIVATE_KEY_LEN            32
#define CM_PUBLIC_KEY_LEN             64
#define CM_SESSIONID_LEN              8
#define CM_TALKKEYINPUT_LEN           80
#define CM_TVB_LEN                    16
#define CM_RSA1024_KEY_LEN            128
#define CM_RSA_MINIMAL_KEY_LEN        8
#define CM_SYM_KEY_LEN                16
#define CM_SIGNATURE_LEN              64
#define CM_EPHEMERAL_POINT_LEN        64
#define CM_BORROW_SERVERID_LEN        8

#define CM_MAX_COMPANY_LEN            32
#define CM_MAX_STRING_LEN             256
#define CM_MAX_PASSWORD_LEN           64




#define CM_SET_VERSION(a,b,c) (((a) & 0xff) << 24) | (((b) & 0xff) << 16) \
    | ((c) & 0xffff)

#define CM_GET_MAJOR_VERSION(v) (((v) >> 24) & 0xff)

#define CM_GET_MINOR_VERSION(v) (((v) >> 16) & 0xff)

#define CM_GET_BUILD_VERSION(v) ((v) & 0xffff)



typedef void* HCMSysEntry;



#define CM_GF_FILEBASED               0x0000
#define CM_GF_BOXBASED                0x0001
#define CM_GF_FI_RESERVED             0x8000



#define CM_GF_ADD_FIRMITEM            0x0000
#define CM_GF_UPDATE_FIRMITEM         0x0001
#define CM_GF_DELETE_FIRMITEM         0x0002
#define CM_GF_ADD_PRODUCTITEM         0x0003
#define CM_GF_UPDATE_PRODUCTITEM      0x0004
#define CM_GF_DELETE_PRODUCTITEM      0x0005
#define CM_GF_SET_BOXCONTROL          0x0006
#define CM_GF_SET_BOXLOCK             0x0007
#define CM_GF_SET_FIRMKEY             0x0008
#define CM_GF_SET_USERKEY             0x0009
#define CM_GF_ADD_ENABLEBLOCK         0x000a
#define CM_GF_UPDATE_ENABLEBLOCK      0x000b
#define CM_GF_DELETE_ENABLEBLOCK      0x000c
#define CM_GF_ATTACH_ENABLEBLOCK      0x000d
#define CM_GF_DETACH_ENABLEBLOCK      0x000e
#define CM_GF_SET_ENABLEBLOCK         0x0011
#define CM_GF_ENABLEITEM              0x0012
#define CM_GF_DISABLEITEM             0x0013
#define CM_GF_TEMPENABLEITEM          0x0014
#define CM_GF_SET_BOXPASSWORD         0x002f
#define CM_GF_CHANGE_BOXPASSWORD      0x003f
#define CM_GF_RESET_BOXPASSWORD       0x004f
#define CM_GF_UPDATECHECKOUT_BORROW   0x005f
#define CM_GF_SET_BOXPASSWORD2        0x006f

#define CM_GF_SET_SYSTEMTIME          0x007f

#define CM_GF_ITEM_MASK               0x007f


#define CM_GF_PRODUCTCODE             0x00000001
#define CM_GF_FEATUREMAP              0x00000002
#define CM_GF_EXPTIME                 0x00000004
#define CM_GF_ACTTIME                 0x00000008
#define CM_GF_UNITCOUNTER             0x00000010
#define CM_GF_PROTDATA                0x00000020
#define CM_GF_EXTPROTDATA             0x00000040
#define CM_GF_HIDDENDATA              0x00000080
#define CM_GF_SECRETDATA              0x00000100
#define CM_GF_USERDATA                0x00000200
#define CM_GF_TEXT                    0x00000400
#define CM_GF_USAGEPERIOD             0x00000800
#define CM_GF_LICENSEQUANTITY         0x00001000
#define CM_GF_BORROWCLIENT            0x00002000
#define CM_GF_BORROWSERVER            0x00004000
#define CM_GF_COLI                    0x00008000
#define CM_GF_PIO_MASK                0x0000ffff
#define CM_GF_MAINTENANCE_PERIOD      0x00010000
#define CM_GF_PIO_MASK_2              0x000fffff


#define CM_GF_DATA                    0x0001
#define CM_GF_FUC                     0x0002
#define CM_GF_SERIAL                  0x0004


#define CM_TIME_OFFSET_TO_UNIX_TIME 946684800






typedef struct __CMBOXCONTROL {
  CMUSHORT musIndicatorFlags;
  CMUSHORT musSwitchFlags;
  CMULONG mulReserve;
} CMBOXCONTROL;


typedef struct __CMBOXINFO {
  CMBYTE mbMajorVersion;
  CMBYTE mbMinorVersion;
  CMUSHORT musBoxMask;
  CMULONG mulSerialNumber;
  CMUSHORT musBoxKeyId;
  CMUSHORT musUserKeyId;
  CMBYTE mabBoxPublicKey[CM_PUBLIC_KEY_LEN];
  CMBYTE mabSerialPublicKey[CM_PUBLIC_KEY_LEN];
  CMULONG mulReserve;
} CMBOXINFO;


typedef struct __CMTIME {
  CMUSHORT musYear;
  CMUSHORT musMonth;
  CMUSHORT musDay;
  CMUSHORT musHours;
  CMUSHORT musMinutes;
  CMUSHORT musSeconds;
  CMULONG mulSecondsSince01_01_2000;
} CMTIME;




typedef struct __CMBORROWDATA {
  CMULONG mulStatus;
  CMUSHORT midEnableBlock;
  CMUSHORT midCps;
  CMULONG mulFirmCode;
  CMULONG mulProductCode;
  CMULONG mulFeatureMap;
  CMUSHORT musReserved;
  CMUSHORT musBoxMask;
  CMULONG mulBoxSerial;
  CMBYTE mabSerialPublicKey[CM_PUBLIC_KEY_LEN];
  CMBYTE mabServerID[CM_BORROW_SERVERID_LEN];
  char mszClientName[128];
  CMBYTE mabTrailingValidationBlock[CM_TVB_LEN];
  CMULONG mulClientRequestTime;
  CMBYTE mabReserved[8];
} CMBORROWDATA;





#define CM_ACCESS_USERLIMIT           0x00000000
#define CM_ACCESS_NOUSERLIMIT         0x00000100
#define CM_ACCESS_EXCLUSIVE           0x00000200
#define CM_ACCESS_STATIONSHARE        0x00000300
#define CM_ACCESS_CONVENIENT          0x00000400

#define CM_ACCESS_STRUCTMASK          0x00000700


#define CM_ACCESS_FORCE               0x00010000

#define CM_ACCESS_CHECK_FSB           0x00020000

#define CM_ACCESS_CHECK_CTSB          0x00040000

#define CM_ACCESS_SUBSYSTEM           0x00080000

#define CM_ACCESS_FIRMITEM            0x00100000


#define CM_ACCESS_BORROW_ACCESS       0x01000000

#define CM_ACCESS_BORROW_RELEASE      0x02000000

#define CM_ACCESS_BORROW_VALIDATE     0x04000000

#define CM_ACCESS_BORROW_IGNORESTATE  0x08000000




#define CM_FSBFEATURECODE_ADDFI            0x00000001

#define CM_FSBFEATURECODE_DELETEFI         0x00000002

#define CM_FSBFEATURECODE_UPDATEFI         0x00000004

#define CM_FSBFEATURECODE_ADDPI            0x00000008

#define CM_FSBFEATURECODE_DELETEPI         0x00000010

#define CM_FSBFEATURECODE_UPDATEPI         0x00000020

#define CM_FSBFEATURECODE_ADDEB            0x00000040

#define CM_FSBFEATURECODE_DELETEEB         0x00000080

#define CM_FSBFEATURECODE_UPDATEEB        0x00000100

#define CM_FSBFEATURECODE_ATTACHEB         0x00000200

#define CM_FSBFEATURECODE_GETBOXTIMESIGN   0x00002000

#define CM_FSBFEATURECODE_DELETEFISIGN     0x00004000

#define CM_FSBFEATURECODE_LISTSIGN         0x00008000

#define CM_FSBFEATURECODE_ENCRYPT          0x00010000

#define CM_FSBFEATURECODE_PRICEDEDUCT      0x00020000

#define CMACT_FSBFEATURECODE_SERIALNUMBERS 0x00040000

#define CMACT_FSBFEATURECODE_NONELICENSES 0x00080000 


  



#define CM_CRED_LICENSE_LOCATION_LOCAL    0x0001 

#define CM_CRED_LICENSE_LOCATION_LAN      0x0002 
#define CM_CRED_LICENSE_LOCATION_MASK     0x0007


#define CM_CRED_HANDLE_ACCESS_ENTRY       0x0008 

#define CM_CRED_HANDLE_ACCESS_FI          0x0010

#define CM_CRED_HANDLE_ACCESS_BOX         0x0018

#define CM_CRED_HANDLE_ACCESS_SUBSYSTEM   0x0020
#define CM_CRED_HANDLE_ACCESS_MASK        0x0038 


typedef struct __CMCREDENTIAL {
  CMULONG mulPID;
  CMULONG mulSession;
  CMULONG mulCleanupTime;
  CMULONG mulMaxLifeTime;
  CMULONG mulCreationTime;
  CMULONG mulAccessCtrl;
  CMULONG mulExpirationTime; 
  CMULONG mulUserDefinedID;
  char mszUserDefinedText[128];
  char mszUsername[32];
  CMULONG mulOtherBorrowFirmCode;
  CMULONG mulOtherBorrowProductCode;
  CMULONG mulOtherBorrowFeatureMap;
  CMULONG mulOtherBorrowSerial;
  CMUSHORT musOtherBorrowMask;

} CMCREDENTIAL;


typedef struct __CMACCESS2 {
  CMULONG mflCtrl;
  CMULONG mulFirmCode;
  CMULONG mulProductCode;
  CMULONG mulFeatureCode; 
  CMULONG mulUsedRuntimeVersion; 

  CMULONG mulProductItemReference;

  CMBYTE  mbMinBoxMajorVersion;
  CMBYTE  mbMinBoxMinorVersion;
  CMUSHORT musBoxMask;
  CMULONG mulSerialNumber;


  char    mszServername[128]; 


  CMCREDENTIAL mcmCredential;

  CMTIME mcmReleaseDate;
} CMACCESS2;




#define CM_AUTH_FIRMKEY               0x00000000
#define CM_AUTH_HIDDENDATA            0x00000001
#define CM_AUTH_SECRETDATA            0x00000002
#define CM_AUTH_SERIALKEY             0x00000003
#define CM_AUTH_BOXKEY                0x00000004
#define CM_AUTH_KSMASK                0x00000007

#define CM_AUTH_DIRECT                0x00000000
#define CM_AUTH_EXTENDED              0x00010000
#define CM_AUTH_SERIAL                0x00020000
#define CM_AUTH_EXTENDED2             0x00030000
#define CM_AUTH_AMMASK                0x00030000

typedef struct __CMAUTHENTICATE {
  CMULONG mflCtrl;
  CMULONG mulKeyExtType;
  CMULONG mulFirmCode;
  CMULONG mulProductCode;
  CMULONG mulEncryptionCodeOptions;
  CMULONG mulFeatureCode;
  CMBOXINFO mcmBoxInfo;
  CMBYTE mabDigest[CM_DIGEST_LEN];
} CMAUTHENTICATE;





typedef struct __CMBOXENTRY {
  CMULONG mflFiCtrl;
  CMULONG mulFirmCode;
  CMUSHORT musFirmAccessCounter;
  CMUSHORT musReserve1;
  CMULONG mulFirmUpdateCounter;
  CMULONG mulFirmPreciseTime;
  CMUSHORT mausFirmItemText[CM_MAX_STRING_LEN];
  CMULONG mflSetPios;
  CMULONG mulProductCode;
  CMULONG mulFeatureMap;
  CMULONG mulUnitCounter;
  CMTIME mcmExpirationTime;
  CMTIME mcmActivationTime;
  CMBYTE mfbDependencyPC;
  CMBYTE mfbDependencyFM;
  CMBYTE mfbDependencyUC;
  CMBYTE mfbDependencyET;
  CMBYTE mfbDependencyAT;
  CMBYTE mbReserve;
  CMUSHORT musProductItemRef;
} CMBOXENTRY;


#define CM_BE_PRODUCTCODE             CM_GF_PRODUCTCODE
#define CM_BE_FEATUREMAP              CM_GF_FEATUREMAP
#define CM_BE_EXPTIME                 CM_GF_EXPTIME
#define CM_BE_ACTTIME                 CM_GF_ACTTIME
#define CM_BE_UNITCOUNTER             CM_GF_UNITCOUNTER
#define CM_BE_PROTDATA                CM_GF_PROTDATA
#define CM_BE_EXTPROTDATA             CM_GF_EXTPROTDATA
#define CM_BE_HIDDENDATA              CM_GF_HIDDENDATA
#define CM_BE_SECRETDATA              CM_GF_SECRETDATA
#define CM_BE_USERDATA                CM_GF_USERDATA
#define CM_BE_TEXT                    CM_GF_TEXT
#define CM_BE_USAGEPERIOD             CM_GF_USAGEPERIOD
#define CM_BE_LICENSEQUANTITY         CM_GF_LICENSEQUANTITY
#define CM_BE_BORROWCLIENT            CM_GF_BORROWCLIENT
#define CM_BE_BORROWSERVER            CM_GF_BORROWSERVER
#define CM_BE_COLI                    CM_GF_COLI
#define CM_BE_MAINTENANCEPERIOD       0x00010000
#define CM_BE_PIO_MASK                0x0001ffff




typedef struct __CMBOXENTRY2 {

  CMUSHORT musBoxMask;

  CMULONG  mulBoxSerial;

  CMULONG mflFiCtrl;
  CMULONG mulFirmCode;
  CMUSHORT musFirmAccessCounter;
  CMUSHORT musFirmItemRef;
  CMULONG mulFirmUpdateCounter;
  CMULONG mulFirmPreciseTime;
  CMUSHORT mausFirmItemText[CM_MAX_STRING_LEN];


  CMULONG mflSetPios;

  CMULONG mulProductCode;
  CMULONG mulFeatureMap;
  CMTIME  mcmMaintenancePeriodStart;
  CMTIME  mcmMaintenancePeriodEnd;
  CMULONG mulUnitCounter;
  CMTIME mcmExpirationTime;
  CMTIME mcmActivationTime;
  CMULONG mulUsagePeriodLifeTime;
  CMTIME mcmUsagePeriodStartTime;
  CMULONG mulLicenseQuantity;

  CMBYTE mfbDependencyPC;
  CMBYTE mfbDependencyFM;
  CMBYTE mfbDependencyMP;
  CMBYTE mfbDependencyUC;
  CMBYTE mfbDependencyET;
  CMBYTE mfbDependencyAT;
  CMBYTE mfbDependencyUP;
  CMBYTE mfbDependencyLQ;

  CMUSHORT musProductItemRef;

} CMBOXENTRY2; 


typedef struct __CMBOXSECURITY {
  CMULONG midOem;
  CMULONG mulFsbFirmCode;
  CMULONG mulCtsbFirmCode;
  CMULONG mulReserve;
} CMBOXSECURITY;
  

typedef struct __CMBOXTIME {
  CMTIME mcmCertifiedTime;
  CMTIME mcmBoxTime;
  CMTIME mcmSystemTime;
} CMBOXTIME;


typedef struct __CMUSAGEPERIOD {
  CMULONG mulPeriod;
  CMTIME mcmStartTime;
} CMUSAGEPERIOD;
  




#define CM_CRYPT_FIRMKEY              0x00000000
#define CM_CRYPT_HIDDENDATA           0x00000001
#define CM_CRYPT_SECRETDATA           0x00000002
#define CM_CRYPT_KSMASK               0x00000003

#define CM_CRYPT_AES                  0x00000000
#define CM_CRYPT_ECIES                0x01000000
#define CM_CRYPT_ECIES_STD            0x02000000
#define CM_CRYPT_AES_DIRECT           0x03000000
#define CM_CRYPT_RSA                  0x05000000
#define CM_CRYPT_ALGMASK              0xff000000

#define CM_CRYPT_CHKCRC               0x00010000
#define CM_CRYPT_CALCCRC              0x00020000


#define CM_CRYPT_RES1MASK             0xC0000000
#define CM_CRYPT_UCMASK               0x30000000
#define CM_CRYPT_UCCHECK              0x00000000
#define CM_CRYPT_UCIGNORE             0x20000000
#define CM_CRYPT_UCREQUIRED           0x10000000
#define CM_CRYPT_ATMASK               0x0C000000
#define CM_CRYPT_ATCHECK              0x00000000
#define CM_CRYPT_ATIGNORE             0x08000000
#define CM_CRYPT_ATREQUIRED           0x04000000
#define CM_CRYPT_ETMASK               0x03000000
#define CM_CRYPT_ETCHECK              0x00000000
#define CM_CRYPT_ETIGNORE             0x02000000
#define CM_CRYPT_ETREQUIRED           0x01000000
#define CM_CRYPT_MPREQUIRED           0x00100000
#define CM_CRYPT_TOPLAINONLY          0x00200000
#define CM_CRYPT_FACDECREMENT         0x00400000
#define CM_CRYPT_CERTTIME             0x00800000
#define CM_CRYPT_RES2MASK             0x00F00000
#define CM_CRYPT_SAMASK               0x000F0000
#define CM_CRYPT_SAEXCLUSIVE          0x00080000
#define CM_CRYPT_SAUNLIMITED          0x00000000
#define CM_CRYPT_SAUSERLIMIT          0x00040000
#define CM_CRYPT_SASTATIONSHARE       0x00020000
#define CM_CRYPT_RES3MASK             0x0000C000
#define CM_CRYPT_UCDELTAMASK          0x00003FFF
#define CM_CRYPT_MAX                  0xFFFFFFFF



typedef struct __CMBASECRYPT2 {
  CMULONG mflCtrl;
  CMULONG mulKeyExtType;
  CMULONG mulEncryptionCode;
  CMULONG mulEncryptionCodeOptions;
  CMULONG mulFeatureCode;
  CMTIME  mcmReleaseDate;
  CMULONG mulCrc;

} CMBASECRYPT2;

  

typedef struct __CMCRYPT2 {
  CMBASECRYPT2 mcmBaseCrypt;
  CMBYTE mabDirectAesKey[CM_BLOCK_SIZE];
  CMBYTE mabInitKey[CM_BLOCK_SIZE];

} CMCRYPT2;



typedef struct __CMCHIPINFO {
  CMULONG mulFirmwareBuild;
  CMULONG mulFirmwareBuildTop;
  CMULONG mulMdfaLba;
  CMULONG mulReserved;
  CMUSHORT musChipType;
  CMUSHORT musSiliconRevision;
  CMUSHORT midFactory;
  CMUSHORT musProductYear;
  CMUSHORT musLotNumber;
  CMUSHORT midWafer;
  CMUSHORT midChipOnWafer;
  CMUSHORT musDowngradeCount;
} CMCHIPINFO;


typedef struct __CMUSBCHIPINFO {
  CMUSHORT musFirmwareMajor;
  CMUSHORT musFirmwareMinor;
  CMULONG  mulFlashSize;
  char mszNodeDescription[CM_MAX_STRING_LEN];
  CMBYTE mszNodes[CM_MAX_STRING_LEN];
} CMUSBCHIPINFO;



typedef struct __CMINTERNALENTRYINFO {
  CMUSHORT musFirmItemReference;
  CMUSHORT musProductItemReference;
  CMULONG mulFirmItemType;
  CMULONG mulFirmUpdateCounter;

} CMINTERNALENTRYINFO;

typedef struct __CMENTRYDATA {
  CMULONG mflCtrl;
  CMULONG mflDependency;

  CMUINT mcbData;
  CMBYTE mabData[2 * CM_MAX_STRING_LEN];
} CMENTRYDATA;



typedef struct __CMMEMINFO {
  CMUSHORT mcFree4ByteBlock;
  CMUSHORT mcFree8ByteBlock;
  CMUSHORT mcFree16ByteBlock;
  CMUSHORT mcFree32ByteBlock;
  CMUSHORT mcFree64ByteBlock;
  CMUSHORT mcFree128ByteBlock;
  CMUSHORT mcFree256ByteBlock;
  CMUSHORT mcFree512ByteBlock;
} CMMEMINFO;



typedef struct __CMMEMINFO2 {
  CMUSHORT mcFree4ByteBlock;
  CMUSHORT mcFree8ByteBlock;
  CMUSHORT mcFree16ByteBlock;
  CMUSHORT mcFree32ByteBlock;
  CMUSHORT mcFree64ByteBlock;
  CMUSHORT mcFree128ByteBlock;
  CMUSHORT mcFree256ByteBlock;
  CMUSHORT mcFree512ByteBlock;




  CMULONG  mulTotalBytesFree;
  CMULONG  mulCapacity;
} CMMEMINFO2;

  

typedef struct __CMRESERVEFI {
  CMUSHORT musFirmItemRef;
  CMBYTE mabSessionId[2 * CM_SESSIONID_LEN];
  CMBYTE mabReserve[6];
} CMRESERVEFI;




#define CM_SYSTEM_W95                 0x00000000
#define CM_SYSTEM_W98                 0x00000001
#define CM_SYSTEM_WME                 0x00000002
#define CM_SYSTEM_NT4                 0x00000003
#define CM_SYSTEM_W2K                 0x00000004
#define CM_SYSTEM_WXP                 0x00000005
#define CM_SYSTEM_W2003               0x00000006
#define CM_SYSTEM_VISTA               0x00000007
#define CM_SYSTEM_W2008               0x00000008
#define CM_SYSTEM_W7                  0x00000009

#define CM_SYSTEM_WINDOWS             0x00000000
#define CM_SYSTEM_MACOSX              0x00000100
#define CM_SYSTEM_SOLARIS             0x00000200
#define CM_SYSTEM_VXWORKS             0x00000400
#define CM_SYSTEM_WIN_CE              0x00001000
#define CM_SYSTEM_LINUX               0x00010000

#define CM_SYSTEM_PLATFORM_MASK       0x000FFF00
#define CM_SYSTEM_VERSION_MASK        0x000000FF
#define CM_SYSTEM_INVALID_PLATFORM    0xFFFFFFFF

#define CM_SYSTEM_LITTLE_ENDIAN       0x00100000
#define CM_SYSTEM_BIG_ENDIAN          0x00200000
#define CM_SYSTEM_ENDIAN_ORDER_MASK   0x00300000


typedef struct __CMSYSTEM {
  CMULONG midPlatform;
  CMULONG mulSystemKernelVersion;
  CMUSHORT mausIpAddress[CM_IP_ADDRESS_LEN];
  char mszComputerName[CM_MAX_STRING_LEN];
} CMSYSTEM;



typedef struct __CMVERSION {
  CMUSHORT musVersion;
  CMUSHORT musSubVersion;
  CMUSHORT musBuild;
  CMUSHORT musCount;
  CMUSHORT musYear;
  CMUSHORT musMonth;
  CMUSHORT musDay;

} CMVERSION;


  


#define CM_BC_ABSOLUTE                0x0000
#define CM_BC_SWITCH                  0x0001

typedef struct __CMPROGRAM_BOXCONTROL {
  CMULONG mflCtrl;
  CMUSHORT musIndicatorFlags;
  CMUSHORT musReserve;
} CMPROGRAM_BOXCONTROL;


typedef struct __CMVALIDATE_DELETEFI {
  CMULONG mflFiCtrl;
  CMULONG mulFirmCode;
  CMULONG mulSystemTime;
  CMULONG mulFirmUpdateCounter;
  CMBYTE mabTrailingValidationBlock[CM_TVB_LEN];
} CMVALIDATE_DELETEFI;


typedef struct __CMPROGRAM_ADD_FIRMITEM {

  CMUSHORT musFirmItemReference;
  CMUSHORT musFirmItemTypePlain;
  CMBYTE mabPublicLicensorKey[CM_PUBLIC_KEY_LEN];

  CMUSHORT musFirmItemTypeEncrypted;
  CMUSHORT musFirmAccessCounter;
  CMULONG mulFirmUpdateCounter;
  CMULONG mulFirmPreciseTime;
  CMULONG mulReserved;
  CMBYTE mabFirmKey[CM_BLOCKCIPHER_KEY_LEN];
  CMBYTE mabSessionId[2 * CM_SESSIONID_LEN];

  CMUSHORT mcchText;

  CMUSHORT mausText[CM_MAX_STRING_LEN];
} CMPROGRAM_ADD_FIRMITEM;



#define CM_UFI_FAC                    0x0001
#define CM_UFI_FUC                    0x0002
#define CM_UFI_FPT                    0x0004
#define CM_UFI_TEXT                   0x0008
#define CM_UFI_MASK                   0x000f

typedef struct __CMPROGRAM_UPDATE_FIRMITEM {
  CMUSHORT musFirmItemReference;
  CMUSHORT musCtrl;
  CMUSHORT musFirmAccessCounter;
  CMULONG mulFirmUpdateCounter;
  CMULONG mulFirmPreciseTime;
  CMUSHORT mcchText;

  CMUSHORT mausText[1];
} CMPROGRAM_UPDATE_FIRMITEM;


typedef struct __CMPROGRAM_DELETE_FIRMITEM {
  CMUSHORT musFirmItemReference;
  CMBYTE mabTrailingValidationBlock[CM_TVB_LEN];
} CMPROGRAM_DELETE_FIRMITEM;


typedef struct __CMPROGRAM_ADD_PRODUCTITEM {
  CMUSHORT musFirmItemReference;
  CMUSHORT musProductItemSuccessorReference;

  CMBYTE mabProductItemOptionBuffer[1];
} CMPROGRAM_ADD_PRODUCTITEM;

typedef struct __CMPROGRAM_UPDATE_PRODUCTITEM {
  CMUSHORT musFirmItemReference;
  CMUSHORT musProductItemReference;
  CMUSHORT musCtrl;

  CMBYTE mabProductItemOptionBuffer[1];
} CMPROGRAM_UPDATE_PRODUCTITEM;


typedef struct __CMPROGRAM_DELETE_PRODUCTITEM {
  CMUSHORT musFirmItemReference;
  CMUSHORT musProductItemReference;
  CMBYTE mabTrailingValidationBlock[CM_TVB_LEN];
} CMPROGRAM_DELETE_PRODUCTITEM;



typedef struct __CM_DISC_SECTOR {
  CMULONG mulNumberOfRequestedSectors;
  CMULONG mulSectorOffset;
  CMBYTE mabReserved[56];
} CM_DISC_SECTOR;


typedef struct __CM_DISC_STATUS {
  CMULONG mulErrorCode;
  CMULONG mulEnablingBits;
  CMULONG mulDiscSectorsTotal;
  CMULONG mulWriteOnceCount;
  CMBYTE  mabReserved[64];
} CM_DISC_STATUS;


  



typedef struct __CMENABLING_SIMPLEPIN {
  CMBYTE mcbEnableAccessCode;

  CMBYTE mabEnableAccessCode[CM_CHALLENGE_LEN];
} CMENABLING_SIMPLEPIN;


typedef struct __CMENABLING_TIMEPIN {
  CMULONG mulDisableTime;
  CMBYTE mcbEnableAccessCode;
  CMUSHORT mcchText;

  CMBYTE mabBuffer[1];
} CMENABLING_TIMEPIN;





#define CM_EBI_VALID                  0x8000
#define CM_EBI_ENABLED                0x0000
#define CM_EBI_DISABLED               0x0001
#define CM_EBI_TEMPENABLED            0x0002
#define CM_EBI_ENABLING_MASK          0x0003
#define CM_EBI_EXPIRED                0x0100
  

#define CM_EBI_SIMPLEPIN              0x0000
#define CM_EBI_TIMEPIN                0x0010

#define CM_EBI_NODISABLETIME          0xFFFFFFFF

typedef struct __CMENABLING_ENABLEBLOCKITEM {
  CMUSHORT musOption;
  CMBYTE mbIndex;
  CMBYTE mbType;
  union {

    CMENABLING_SIMPLEPIN mcmSimplePin;
    CMENABLING_TIMEPIN mcmTimePin;
  } mEnableType;
} CMENABLING_ENABLEBLOCKITEM;


#define CM_ELUE_VALID                 0x8000
#define CM_ELUE_IFI                   0x0001
#define CM_ELUE_REQUIRED              0x0002
  

#define CM_ELUE_LOCATE                0x0000
#define CM_ELUE_READ                  0x0001
#define CM_ELUE_ENCRYPT               0x0003
#define CM_ELUE_UNITUSE               0x0005
#define CM_ELUE_MODIFY                0x0007
#define CM_ELUE_DETACH                0x00ff




#define CM_WU_DISABLED                0x0001
#define CM_WU_TEMPENABLED             0x0002
#define CM_WU_ACCESSCODE              0x0004
#define CM_WU_DISABLETIME             0x0008
#define CM_WU_TEXT                    0x0010
#define CM_WU_IDENTITY                0x0020
#define CM_WU_FULL                    0x003f
  
typedef struct __CMENABLING_WRITEUPDATE {

  CMBYTE mbEnableBlockIndex;

  CMUSHORT musCtrl;
  CMULONG mulFirmUpdateCounter;
  CMENABLING_ENABLEBLOCKITEM mcmEnableBlockItem;
} CMENABLING_WRITEUPDATE;



#define CM_AC_VALID                   0x8000
#define CM_AC_DISABLED                0x0001
#define CM_AC_TEMPENABLED             0x0002

typedef struct __CMENABLING_APPCONTEXT {
  CMULONG mulFirmCode;
  CMULONG mulProductCode;
  CMBOXINFO mcmBoxInfo;
  CMULONG mflCtrl;
  CMUSHORT midEnableBlockItem;
  CMUSHORT musReserve;
  CMULONG mulFirmUpdateCounter;
  CMULONG midIdentity;
  char mszCompanyName[CM_MAX_COMPANY_LEN];
} CMENABLING_APPCONTEXT;



typedef struct __CMSERIAL {
  CMUINT mulSerial;
  CMUSHORT musMask;
  CMUSHORT musReserved;
} CMSERIAL;



  

#define CMACT_MAX_LEN_LICENSORDATA    4096
  
#define CMACT_MAX_LEN_PRODUCT_SERIAL  128
  
  
  


typedef struct __CMACTREQUEST {
  char mszProductSerialNumber[CMACT_MAX_LEN_PRODUCT_SERIAL];
  CMULONG mulProductSubType;

  CMBYTE mabLicensorData[CMACT_MAX_LEN_LICENSORDATA];
} CMACTREQUEST;



#define CMFAS_SELECT_MASK             0x0000000F
#define CMFAS_SELECT_WILDCARD         0x00000000
#define CMFAS_SELECT_SERIALNUMBER     0x00000001
#define CMFAS_SELECT_FIRMCODE         0x00000002

#define CMFAS_OPT_MASK                0x10000000
#define CMFAS_OPT_IGNORE              0x10000000



#define CMFAS_ITEMTYPE_LICENSE           0x00000001
#define CMFAS_ITEMTYPE_CMACT_LICENSE     0x80000001
#define CMFAS_ITEMTYPE_CMHW_LICENSE      0x40000001
#define CMFAS_ITEMTYPE_CMFIRM_WBC        0x00000002
#define CMFAS_ITEMTYPE_CMACT_FI_TEMPLATE 0x80000004


typedef struct __CMFAS
{
  CMULONG mflSelect;
  CMULONG mulItemType;


  CMULONG mulSerial;
  CMUSHORT musMask;
  CMUSHORT musReserved1;


  CMULONG mulFirmCode;

  CMULONG maulReserved3[20];


  CMULONG mulResult;

  CMULONG maulReserved4[10];
} CMFAS;


#define CM_EC_PRODUCTITEM     0x01
#define CM_EC_FIRMITEM        0x02
#define CM_EC_GLOBALITEM      0x04


  

typedef struct __CMENABLING_CONTEXT {
  CMULONG mulFirmcode;
  CMULONG mulProductcode;
  CMUSHORT musOption;
  CMBYTE mbIndex;
  CMBYTE mbType;
  CMULONG mulDisableTime;
  CMUSHORT mausText[CM_MAX_STRING_LEN];
  CMUSHORT musFlags;
  CMBYTE mbItemType;
  CMBYTE mcbEnableAccessCode;
  CMBYTE mabEnableAccessCode[CM_CHALLENGE_LEN];
  CMUSHORT mausEnablePassword[CM_MAX_PASSWORD_LEN];
  CMBYTE mbEnableLevel;
  CMBYTE mbDisableLevel;
} CMENABLING_CONTEXT;
  
  
  

CODEMETER_API void CMAPIENTRY CmStaticLibOnInit(void);
  

CODEMETER_API void CMAPIENTRY CmStaticLibOnExit(void);




#define CM_ACCESS_LOCAL               0x0000
#define CM_ACCESS_LAN                 0x0001
#define CM_ACCESS_LOCAL_LAN           0x0002
#define CM_ACCESS_LAN_LOCAL           0x0003
#define CM_ACCESS_CMDMASK             0x0003
  
  
CODEMETER_API HCMSysEntry CMAPIENTRY CmAccess2(CMULONG flCtrl, CMACCESS2 *pcmAcc);


CODEMETER_API int CMAPIENTRY CmRelease(HCMSysEntry hcmse);


 
  


#define CM_CRYPT_DIRECT_ENC           0x0000
#define CM_CRYPT_DIRECT_DEC           0x0001

#define CM_CRYPT_STREAM               0x0003
#define CM_CRYPT_AES_ENC_ECB          0x0004
#define CM_CRYPT_AES_DEC_ECB          0x0005
#define CM_CRYPT_AES_ENC_CFB          0x0006
#define CM_CRYPT_AES_DEC_CFB          0x0007
#define CM_CRYPT_AES_ENC_CBC          0x0008
#define CM_CRYPT_AES_DEC_CBC          0x0009

#define CM_CRYPT_AES_ENC_CBC_DIRECT   0x000a
#define CM_CRYPT_AES_DEC_CBC_DIRECT   0x000b


#define CM_CRYPT_CMDMASK              0x000f

#define CM_CRYPT_AUTOKEY              0x0100



CODEMETER_API int CMAPIENTRY CmCrypt2(HCMSysEntry hcmse, CMULONG flCtrl,
    CMCRYPT2 *pcmCrypt2, void* pvDest, CMUINT cbDest);

CODEMETER_API int CMAPIENTRY CmCryptEcies(CMBYTE* pbPublicKey,
    CMUINT cbPublicKey, CMBYTE* pbData, CMUINT cbData);

                                                

  

#define  CM_GBC_ALLENTRIES             0x0000
#define  CM_GBC_FI                     0x0001
#define  CM_GBC_BOX                    0x0002
#define  CM_GBC_USELOCALTIME           0x1000
  

CODEMETER_API int CMAPIENTRY CmGetBoxContents2(HCMSysEntry hcmse, CMULONG flCtrl,
    CMULONG ulFirmCode, CMBOXINFO *pcmBoxInfo,
    CMBOXENTRY2 *pcmBoxEntry, CMUINT cbBoxEntry);
    

#define  CM_GB_ALLPORTS                0x0000
#define  CM_GB_USB                     0x0001
#define  CM_GB_SIM                     0x0002
#define  CM_GB_ACT                     0x0004
#define  CM_GB_PORT_MASK               0x000F
  
CODEMETER_API int CMAPIENTRY CmGetBoxes(HCMSysEntry hcmse, CMULONG idPort,
    CMBOXINFO *pcmBoxInfo, CMUINT cbBoxInfo);


#define CM_GEI_BOXCONTROL             0x0000
#define CM_GEI_BOXINFO                0x0001
#define CM_GEI_BOXSECURITY            0x0002
#define CM_GEI_BOXTIME                0x0003
#define CM_GEI_ENTRYDATA              0x0004
#define CM_GEI_ENTRYINFO              0x0005
#define CM_GEI_INTERNALENTRYINFO      0x0006
#define CM_GEI_MEMINFO                0x0007
#define CM_GEI_SIGNEDLIST             0x0008
#define CM_GEI_SIGNEDTIME             0x0009
#define CM_GEI_SYSTEM                 0x000a
#define CM_GEI_VERSION                0x000b
#define CM_GEI_ENABLEBLOCKITEMS       0x000c
#define CM_GEI_ENABLELOOKUPITEMS_FI   0x000d
#define CM_GEI_ENABLELOOKUPITEMS_PI   0x000e
#define CM_GEI_CHIPINFO               0x000f
#define CM_GEI_BOXSTATUS              0x0010
#define CM_GEI_USBCHIPINFO            0x0011
#define CM_GEI_NETINFO_CLUSTER        0x0012
#define CM_GEI_NETINFO_USER           0x0013
#define CM_GEI_CREDENTIAL             0x0014
#define CM_GEI_SECURITYVERSION        0x0015
#define CM_GEI_NETINFO_USER_EXT       0x0016
#define CM_GEI_MEMINFO2               0x0017
#define CM_GEI_ACT_LICENSE_INFO       0x0018
#define CM_GEI_ACT_ERROR_INFO         0x0019
#define CM_GEI_CMACTVERSION           0x0020
#define CM_GEI_BORROWCLIENT           0x0030
#define CM_GEI_BORROWDATA             0x0031
#define CM_GEI_BORROWITEMS            0x0032
#define CM_GEI_ENTRYINFO2             0x0033
#define CM_GEI_ENABLEINFO             0x0034
#define CM_GEI_ACT_LICENSE_INFO2      0x0035

#define CM_GEI_CMDMASK                0x00ff
#define CM_GEI_USELOCALTIME           0x1000
#define CM_GEI_INDEXMASK              0xff000000
  

#define CM_TIME_OFFSET_TO_UNIX_TIME 946684800


#define CM_BOXSTATUS_LOWMEMORY         0x00000001
#define CM_BOXSTATUS_REPLUG            0x00000002
#define CM_BOXSTATUS_HASFLASH          0x00000004
#define CM_BOXSTATUS_ISCMACT           0x00000008
#define CM_BOXSTATUS_REMOVABLE         0x00000010
#define CM_BOXSTATUS_BATTERY_POWERED_CLOCK_USED 0x00000020
#define CM_BOXSTATUS_FEATURE_MASK      0x000000FF

#define CM_ACTSTATUS_FILE              0x00000100
#define CM_ACTSTATUS_LOADED            0x00000200
#define CM_ACTSTATUS_ACTIVATE_BY_CODE  0x00000400
#define CM_ACTSTATUS_ACTIVATE_BY_FILE  0x00000800
#define CM_ACTSTATUS_ACTIVE            0x00001000
#define CM_ACTSTATUS_PROGRAMMABLE      0x00002000
#define CM_ACTSTATUS_INVALID           0x00004000
#define CM_ACTSTATUS_BROKEN            0x00008000
#define CM_ACTSTATUS_PSN_REQUIRED      0x02000000
#define CM_ACTSTATUS_VM_DETECTED       0x04000000 

  
#define CM_BOXSTATUS_CMACT_MASK        0x0F00FF00

#define CM_BOXSTATUS_ENABLED           0x00000000
#define CM_BOXSTATUS_DISABLED          0x00010000
#define CM_BOXSTATUS_TEMPENABLED       0x00020000
#define CM_BOXSTATUS_NOENABLEITEMS     0x00040000
#define CM_BOXSTATUS_AMBIGUOUS         0x00080000
#define CM_BOXSTATUS_MASK              0x000f0000

#define CM_BOXSTATUS_STATE_FUM         0x00100000
#define CM_BOXSTATUS_STATE_LOCKED      0x00200000
#define CM_BOXSTATUS_STATE_MASK        0x00F00000

CODEMETER_API int CMAPIENTRY CmGetInfo(HCMSysEntry hcmse, CMULONG flCtrl,
    void *pvDest, CMUINT cbDest);

#if defined(CONF_ENABLE_CM_GETVERSION) && CONF_ENABLE_CM_GETVERSION
  CODEMETER_API CMULONG CMAPIENTRY CmGetVersion(HCMSysEntry hcmse);
#endif
                                         
                                         
                                         



CODEMETER_API int CMAPIENTRY CmGetLastErrorCode(void);




#if (defined(CONF_ENABLE_CM_GETLASTERRORTEXT) || defined(CONF_ENABLE_CM_GETLASTERRORTEXT2)) && (CONF_ENABLE_CM_GETLASTERRORTEXT || CONF_ENABLE_CM_GETLASTERRORTEXT2)

#define CM_GLET_ERRORTEXT             0x0000
#define CM_GLET_MASK                  0x00FF
#define CM_GLET_UTF8_ENCODING         0x0100
#define CM_GLET_WCHAR_ENCODING        0x0200
#define CM_GLET_ENCODING_MASK         0x0F00

#endif


#if defined(CONF_ENABLE_CM_GETLASTERRORTEXT) && CONF_ENABLE_CM_GETLASTERRORTEXT

CODEMETER_API int CMAPIENTRY CmGetLastErrorText(CMULONG flCtrl,
    char *pszErrorText, CMUINT cbErrorText);
#endif


#define CmSetLastErrorCode(e) CmSetLastErrorCodeLine(e, __LINE__);
CODEMETER_API void CMAPIENTRY CmSetLastErrorCodeLine(int idError, int line);




CODEMETER_API int CMAPIENTRY CmReserveFirmItem(HCMSysEntry hcmse, 
    CMULONG ulFirmCode, CMRESERVEFI *pcmReserveFi);





CODEMETER_API int CMAPIENTRY CmProgram(HCMSysEntry hcmse,
    CMULONG flCtrl, void *pvCtrl, CMUINT cbCtrl,
    void *pvVerify, CMUINT cbVerify);




CODEMETER_API int CMAPIENTRY CmGetRemoteContextBuffer(HCMSysEntry hcmBox,
    CMUINT flCtrl, CMUINT *pulFirmCodes, CMUINT cbFirmCodes,
    void* pvMemBuffer, CMUINT cbMemBuffer, CMUINT* pcbWritten);






#define CMFAS_CTL_CMD_MASK            0x00000003
#define CMFAS_CTL_CMD_LIST            0x00000000
#define CMFAS_CTL_CMD_UPDATE          0x00000001
#define CMFAS_CTL_CMD_UPDATE_EXISTING 0x00000002
#define CMFAS_CTL_CMD_GET_COUNT       0x00000003

#define CMFAS_CTL_OPT_MASK            0x00000010
#define CMFAS_CTL_OPT_ABORT_ON_ERROR  0x00000010

CODEMETER_API int CMAPIENTRY CmExecuteRemoteUpdate(
    HCMSysEntry hcmSubSystem,
    CMULONG flCtrl, void* pMemBuffer, CMUINT cbMemBuffer,
    CMFAS * pCmFasSelect, CMUINT cbCmFasSelect,
    CMFAS * pCmFasResult, CMUINT cbCmFasResult,
    CMUINT *pcbCmFasResultCount);




CODEMETER_API int CMAPIENTRY CmEnablingGetChallenge(HCMSysEntry hcmse,
    CMENABLING_APPCONTEXT *pcmAppContext, CMBYTE *pbChallenge,
    CMUINT cbChallenge);



  
CODEMETER_API int CMAPIENTRY CmCalculateDigest(CMBYTE *pbInput, CMUINT cbInput,
    CMBYTE *pbDigest, CMUINT cbDigest);

CODEMETER_API int CMAPIENTRY CmCalculateSignature(HCMSysEntry hcmse,
    CMAUTHENTICATE *pcmAuth, CMBYTE *pbSignature, CMUINT cbSignature);
                                                  
CODEMETER_API int CMAPIENTRY CmGetPublicKey(HCMSysEntry hcmse,
    CMAUTHENTICATE *pcmAuth, CMBYTE *pbPubKey, CMUINT cbPubKey);

CODEMETER_API int CMAPIENTRY CmValidateSignature(CMAUTHENTICATE *pcmAuth,
    CMBYTE *pbSignature, CMUINT cbSignature,
    CMBYTE *pbPubKey, CMUINT cbPubKey);




#define CM_CONVERT_UTF8_TO_WCHAR        0x0001
#define CM_CONVERT_UTF8_TO_UCS2LE       0x0002
#define CM_CONVERT_UTF8_TO_ASCII        0x0003
#define CM_CONVERT_UTF8_TO_UTF16        0x0004
#define CM_CONVERT_UTF8_TO_LOCAL        0x0005

#define CM_CONVERT_WCHAR_TO_UCS2LE      0x0010
#define CM_CONVERT_WCHAR_TO_UTF8        0x0011
#define CM_CONVERT_WCHAR_TO_ASCII       0x0012
#define CM_CONVERT_WCHAR_TO_UTF16       0x0013
#define CM_CONVERT_WCHAR_TO_LOCAL       0x0014

#define CM_CONVERT_UCS2LE_TO_WCHAR      0x0020
#define CM_CONVERT_UCS2LE_TO_UTF8       0x0021
#define CM_CONVERT_UCS2LE_TO_ASCII      0x0022
#define CM_CONVERT_UCS2LE_TO_UTF16      0x0023
#define CM_CONVERT_UCS2LE_TO_LOCAL      0x0024

#define CM_CONVERT_ASCII_TO_WCHAR       0x0030
#define CM_CONVERT_ASCII_TO_UCS2LE      0x0031
#define CM_CONVERT_ASCII_TO_UTF8        0x0032
#define CM_CONVERT_ASCII_TO_UTF16       0x0033
#define CM_CONVERT_ASCII_TO_LOCAL       0x0034

#define CM_CONVERT_UTF16_TO_UTF8        0x0040
#define CM_CONVERT_UTF16_TO_UCS2LE      0x0041
#define CM_CONVERT_UTF16_TO_WCHAR       0x0042
#define CM_CONVERT_UTF16_TO_ASCII       0x0043
#define CM_CONVERT_UTF16_TO_LOCAL       0x0044

#define CM_CONVERT_LOCAL_TO_UTF8        0x0050
#define CM_CONVERT_LOCAL_TO_UCS2LE      0x0051
#define CM_CONVERT_LOCAL_TO_WCHAR       0x0052
#define CM_CONVERT_LOCAL_TO_ASCII       0x0053
#define CM_CONVERT_LOCAL_TO_UTF16       0x0054

#define CM_CONVERT_MASK                 0x00FF

CODEMETER_API int CMAPIENTRY CmConvertString(CMUINT flCtrl,
    const void *pszSrc, void *pszDst, CMUINT cbDst);




#define CM_GF_ACT_CREATE_LICENSE_INFO     0x0011
#define CM_GF_ACT_SETUP_LICENSE           0x0012
#define CM_GF_ACT_SETUP_LICENSE_STEP1     0x0013
#define CM_GF_ACT_SETUP_LICENSE_STEP2     0x0014
#define CM_GF_ACT_REGISTER                0x0015
#define CM_GF_ACT_UPDATE_LICENSE_DATA     0x0016
#define CM_GF_ACT_ACTIVATION_CODE         0x0017
#define CM_GF_ACT_LICENSE_BY_CODE         0x0018
#define CM_GF_ACT_REQUEST                 0x0019
#define CM_GF_ACT_CREATE_ACTIVATION_STEP1 0x001a
#define CM_GF_ACT_CREATE_ACTIVATION_STEP2 0x001b
#define CM_GF_ACT_CREATE_ACTIVATION_STEP3 0x001c
#define CM_GF_ACT_REMOVE                  0x001d
#define CM_GF_ACT_GETFILEINFO             0x001e
#define CM_GF_ACT_GET_INSTALLATION_ID     0x001f
#define CM_GF_ACT_SPLIT_INSTALLATION_ID   0x0020
#define CM_GF_ACT_GET_TEMPLATE_KEY        0x0021
#define CM_GF_ACT_SPLIT_ACTIVATION_CODE   0x0022 
#define CM_GF_ACT_GETFILEINFO2            0x0023
#define CM_GF_ACT_CREATE_ACTIVATION_STEP2A 0x0024

#define CM_GF_ACT_MASK                    0x007f

CODEMETER_API int CMAPIENTRY CmActLicenseControl(HCMSysEntry hcmse,
    CMULONG flCtrl, const void *pvData, CMUINT cbData,
    void *pvReturn, CMUINT cbReturn);






#define CM_SECURE_DISC_STATUS             0x00000200
#define CM_SECURE_DISC_READ               0x00000201
#define CM_SECURE_DISC_WRITE              0x00000202

#define CM_SECURE_DISC_VERIFY_MASK        0x00030000


#define CM_SECURE_DISC_VERIFY_ON          0x00010000
#define CM_SECURE_DISC_VERIFY_OFF         0x00020000
#define CM_SECURE_DISC_VERIFY_AUTO        0x00000000

CODEMETER_API int CMAPIENTRY CmSecureDiscRead(HCMSysEntry hcmse, CMULONG flCtrl,
    CM_DISC_STATUS *status, const CM_DISC_SECTOR *sector,
    CMBYTE *data, CMUINT cbData);

CODEMETER_API int CMAPIENTRY CmSecureDiscWrite(HCMSysEntry hcmse, CMULONG flCtrl,
    CM_DISC_STATUS *status, const CM_DISC_SECTOR *sector,
    const CMBYTE *data, CMUINT cbData);

CODEMETER_API int CMAPIENTRY CmExtendedDiscControl(HCMSysEntry hcmse, CMULONG flCtrl,
    void *data, CMUINT cbData);




CODEMETER_API CMTIME CMAPIENTRY CmConvertTime(CMULONG ulTime);
CODEMETER_API CMULONG CMAPIENTRY CmMakeTime(const CMTIME* pcmTime);
  
CODEMETER_API int CMAPIENTRY CmSetSystemTime( HCMSysEntry hcmse, CMTIME * newSystemTime );
#if defined(__cplusplus)
}
#endif

#endif
