/*************************************************************************************************
 FILE:           scd_ssc_test.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:   SCD SSC - SmartCard System Security Controller
 DESCRIPTION:    test class declaration
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 10.10.2015      | sva1fh                | initial version

 ************************************************************************************************/

#ifndef SCD_SSC_TEST_H_
#define SCD_SSC_TEST_H_

#include "scd_ssc_clienthandler_ALD.h"
#include "scd_ssc_utility.h"
#include "scd_ssc_property.h"
#include "scd_ssc_smartcardhandler.h"

#include <cstdio>
#include <iostream>
#include <fstream>
#include <unistd.h>
#include <cstring>


class scd_ssc_tclTest
{
public:

/*************************************************************************************************
* FUNCTION: scd_ssc_tclTest
* DESCRIPTION: Constructor
* PARAMETER:
* RETURNVALUE:

	*************************************************************************************************/
	scd_ssc_tclTest();

/*************************************************************************************************
* FUNCTION: ~scd_ssc_tclTest
* DESCRIPTION: destructor
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	virtual ~scd_ssc_tclTest();

/*************************************************************************************************
* FUNCTION: run_ald_challenge_test
* DESCRIPTION: test the data received from ALD (challenge data)
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	void run_ald_challenge_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
			                    scd_ssc_tclProperty *m_poProperty, scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
* FUNCTION: run_smartcard_discovery_test
* DESCRIPTION: test the data received from a smartcard (using udev)
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	void run_smartcard_discovery_test(scd_ssc_tclSmartcardHandler *m_poSmartcardHandler,
			                          scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
* FUNCTION: run_ald_smartcard_challenge_response_test
* DESCRIPTION: test the challenge and response data (before sending response data to ALD)
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	void run_ald_smartcard_challenge_response_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
			scd_ssc_tclProperty *m_poProperty, scd_ssc_tclUtility  *m_poUtility,
			scd_ssc_tclSmartcardHandler *m_poSmartcardHandler, scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
* FUNCTION: run_codemeter_initialization_test
* DESCRIPTION: test the codemeter initialization
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	void run_codemeter_initialization_test(scd_ssc_tclSmartcardHandler *m_poSmartcardHandler,
			scd_ssc_tclProperty *m_poProperty, scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
			scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
* FUNCTION: run_ald_get_status_test
* DESCRIPTION: test the current unlock level status
* PARAMETER:
* RETURNVALUE:

*************************************************************************************************/
	void run_ald_get_status_test(scd_ssc_tclClientHandler_ALD * m_poClientHandlerALD,
			                   scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger);


};

#endif /* SCD_SSC_TEST_H_ */
