/*************************************************************************************************
 FILE:           scd_ssc_clienthandler_ALD.h
 PROJECT:        GM3Gen MY17 - Security
 SW-COMPONENT:
 DESCRIPTION:    Declaration of the ALD client class
 AUTHOR:         sva1fh
 COPYRIGHT:      RBNA

 HISTORY:
 Date            | Author                | Modification
 05.10.2015      | sva1fh                | initial version

 ************************************************************************************************/
#ifndef SCD_SSC_CLIENTHANDLER_ALD_H_
#define SCD_SSC_CLIENTHANDLER_ALD_H_

#include "scd_ssc_property.h"
#include "scd_ssc_utility.h"
#include "scd_ssc_logger.h"

#include <cstring>
#include <cstddef>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <glib.h>
#include <Python.h>

/* add these two below if using fork/execlp                                                     */

//#include <unistd.h>
//#include <sys/wait.h>


class scd_ssc_tclClientHandler_ALD
{
public:
/*************************************************************************************************
	FUNCTION: scd_ssc_tclClientHandler_ALD
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: constructor

*************************************************************************************************/
	scd_ssc_tclClientHandler_ALD();


/*************************************************************************************************
	FUNCTION: operator=
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: assignment operator

*************************************************************************************************/
	scd_ssc_tclClientHandler_ALD & operator=(const scd_ssc_tclClientHandler_ALD & oscd_ssc);

/*************************************************************************************************
	FUNCTION: scd_ssc_tclClientHandler_ALD
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: copy constructor

*************************************************************************************************/
	scd_ssc_tclClientHandler_ALD(const scd_ssc_tclClientHandler_ALD & oscd_ssc);

/*************************************************************************************************
	FUNCTION: scd_ssc_tclClientHandler_ALD
	PARAMETERS:
	RETURN VALUE:
	DESCRIPTION: destructor

*************************************************************************************************/
	virtual ~scd_ssc_tclClientHandler_ALD();

/*************************************************************************************************
	FUNCTION: challenge
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE: bool, true - success, false - failed
	DESCRIPTION:  gets data from ALD (96 bytes)

*************************************************************************************************/
	bool challenge(scd_ssc_tclProperty *ald_property,scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: response
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: sends 1400 bytes of data to ALD

*************************************************************************************************/
	bool response(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: lockDevice
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:   bool, true - success, false - failed
	DESCRIPTION: locks the device

*************************************************************************************************/
	bool lockDevice(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: getStatus
	PARAMETERS: scd_ssc_tclProperty
	RETURN VALUE:   bool, true - success, false - failed
	DESCRIPTION: gets the current unlock level status

*************************************************************************************************/
	bool getStatus(scd_ssc_tclProperty *ald_property, scd_ssc_tclLogger  *m_poLogger);

private:
/*************************************************************************************************
	FUNCTION: initConnection
	PARAMETERS:
	RETURN VALUE:   bool, true - success, false - failed
	DESCRIPTION: makes a D-Bus connection

*************************************************************************************************/
	bool initConnection(scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: sendArgAndReply
	PARAMETERS: unsigned int op, const char *name, const char *path, const char *iface,
			             const char *method, char *in, char *out, unsigned int *int_out,
			             const unsigned int in_size, const unsigned int out_size
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: calls a function that sends args and reads the return value

*************************************************************************************************/
	bool sendArgAndReply(unsigned int op, const char *name, const char *path, const char *iface,
			             const char *method, char *in, char *out, unsigned int *int_out,
			             const unsigned int in_size, const unsigned int out_size,
			             scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: sendAndReply
	PARAMETERS: const char *name, const char *path, const char *iface, const char *method,
			          unsigned int *result_out
	RETURN VALUE:  bool, true - success, false - failed
	DESCRIPTION: calls a function that sends no arg and reads the return data

*************************************************************************************************/
	bool sendAndReply(const char *name, const char *path, const char *iface, const char *method,
			          unsigned int *result_out,
			          scd_ssc_tclLogger  *m_poLogger);

/*************************************************************************************************
	FUNCTION: sendSignal
	PARAMETERS: const char *name, const char *path, const char *iface, const char *signal
	RETURN VALUE: bool, true - success, false - failed
	DESCRIPTION: sends a signal

*************************************************************************************************/
	bool sendSignal(const char *name, const char *path, const char *iface, const char *signal,
			scd_ssc_tclLogger  *m_poLogger);

	/* D-Bus objects                                                                            */
	DBusConnection *m_ptrConnection;
	DBusMessage *reply;
	DBusMessage *msg;
	DBusError error;
	DBusMessageIter iter, subiter;
	DBusPendingCall *pending;

};

#endif /* SCD_SSC_CLIENTHANDLER_ALD_H_ */
