/**
 * definitions.h - store enumerations and defines
 * ----------------------------------------------------------------------------
 * Author:	Dietmar Wegner
 *			Mourad Goumrhar
 *			Mirko Lochau
 *			Michael Reinhold
 *
 * Version History
 * ----------------------------------------------------------------------------
 * 06.11.2014	Initial Version
 * 11.11.2014	Refactoring done, removed unused defines, commamnd line binary 
 *				product introduced
 * 
 */

#ifndef DEFINITIONS_H
#define DEFINITIONS_H

enum VKeyGenResultExOpt
{
  KGREO_Ok = 0,
  KGREO_BufferTooSmall = 1,
  KGREO_SecurityLevelInvalid = 2,
  KGREO_VariantInvalid = 3,
  KGREO_UnspecifiedError = 4,
  KGREO_Access=5,
  KGREO_Boxes0=6,
  KGREO_BoxesMore=7,
  KGREO_Sign=8,
  KGREO_Counter=9,
  KGREO_Level=10,
  KGREO_Init=11,
};

#define LEN_SEED 96		// total length of the seed in bytes

// ****** SEED Content / Structure we get from CANoe - in total 96 bytes
#define START_RANDOM 0
#define LEN_RANDOM 16	

#define START_TIMESTAMP1	(START_RANDOM+LEN_RANDOM)
#define LEN_TIMESTAMP1	4

#define START_TIMESTAMP2	(START_TIMESTAMP1+LEN_TIMESTAMP1)
#define LEN_TIMESTAMP2	4

#define START_ECU_SN	(START_TIMESTAMP2+LEN_TIMESTAMP2)
#define LEN_ECU_SN		8

#define START_KEY_ID	(START_ECU_SN+LEN_ECU_SN)
#define LEN_KEY_ID		4

#define START_ECU_ID	(START_KEY_ID+LEN_KEY_ID)
#define LEN_ECU_ID		16

#define START_ECU_ID	(START_KEY_ID+LEN_KEY_ID)
#define LEN_ECU_ID		16

#define START_RESERVED	(START_ECU_ID+LEN_ECU_ID)
#define LEN_RESERVED	LEN_SEED-START_RESERVED
// ****** 

// ****** KEY Content / Structure - in total 1400 bytes
#define START_SEED 0

#define START_SMARTCARD_SN (START_SEED+LEN_SEED)
#define LEN_SMARTCARD_SN 25

#define START_LOCKLEVEL (START_SMARTCARD_SN+LEN_SMARTCARD_SN)
#define LEN_LOCKLEVEL 4

#define START_PUBLIC_KEY (START_LOCKLEVEL+LEN_LOCKLEVEL)
#define LEN_PUBLIC_KEY 512

#define START_RES (START_PUBLIC_KEY+LEN_PUBLIC_KEY)
#define LEN_RES 251

#define START_SIGNATURE (START_RES+LEN_RES)
#define LEN_SIGNATURE 512
// ****** 

#define LEN_KEY (START_SIGNATURE+LEN_SIGNATURE) // 1400 bytes

#define LEN_DATA_TO_BE_SIGNED START_SIGNATURE	// 888 bytes	

#define SIGNATURE_SIZE 256	// RSA 2048

#endif //DEFINITIONS_H
