#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/un.h>

char *lxc_name = NULL;

static void print_usage(const char *name)
{
    fprintf(stderr, "usage: %s -n/--lxc-name LXC_NAME [-h/--help]\n", name);
}

static void parseLongOptarg(int argc, char** argv)
{
    int long_index = 0;
    int opt = 0;

    struct option long_options[] = {
        {"lxc-name",    required_argument,       NULL,  'n' },
        {"help",        no_argument,             NULL,  'h' },
        {0,                             0,          0,   0  }
    };

    while ((opt = getopt_long(argc, argv,"n:h", long_options, &long_index )) != -1)
    {
        switch (opt) {
            case 'n':
                lxc_name = optarg;
                break;
            case 'h':
                print_usage(argv[0]);
                exit(0);
                break;
            default:
                break;
        }
    }

    if (lxc_name == NULL)
    {
        print_usage(argv[0]);
        exit(-1);
    }
}

int main(int argc, char **argv)
{
    int isorunSock;
    struct sockaddr_un isorunAddr;

    parseLongOptarg(argc, argv);

    char socketpath[80];
    snprintf(socketpath, 80, "/tmp/shared/%s_lcm/isorun.sock", lxc_name);

    isorunSock = socket(AF_UNIX, SOCK_DGRAM, 0);

    if (isorunSock < 0)
    {
        perror("socket");
        return -1;
    }

    isorunAddr.sun_family = AF_UNIX;
    strncpy(isorunAddr.sun_path, socketpath, sizeof(isorunAddr.sun_path));

    char buf[]="RESTART=1";
    printf("Sending to socket: %s\n", buf);
    ssize_t res = sendto(isorunSock, buf, sizeof(buf), 0,(struct sockaddr*) &isorunAddr, sizeof(isorunAddr));
    if (res == -1)
    {
        perror("sendto");
        close(isorunSock);
        return -1;
    }

    close(isorunSock);
    return 0;
}
