/**
 * TODO: add fancy header?
 */

#ifndef SERVICE_H_
#define SERVICE_H_

#include <unistd.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

#if 0
typedef enum restartVals {
    NO,
    ON_SUCCESS,
    ON_FAILURE,
    ON_ABNORMAL,
    ON_WATCHDOG,
    ON_ABORT,
    ALWAYS
} restartVal;
#endif


// structure for informations on one service
typedef struct service
{
    pid_t pid;
    bool mustnotify;
    unsigned int watchdogsec;
    unsigned int watchdogcd;    /** watchdog count down */
    char* cmdline;
    char* envline;
    //restartVal resval;
    char restartstr[16];        /** not used?? */
    char typestr[16];
    char workingdirstr[128];
    char notifyaccessstr[8];
} Service;

/**
 * Will set ISOINIT_SOCK_PATH environment for service started by isoinit
 * @param path Socket path
 */
void SERVICE_SetIsoinitSockPath(const char *path);

/**
 * TODO
 * @param dbgpath - NULL or the path to a folder where STDOUT/ERR should be redirected to file
 */
void SERVICE_SetDbgPath(const char *dbgpath);


/**
 * @brief scan service directory
 *
 * This function will scan a given service directory. All *.service files in
 * this directory will be sorted and evaluated. Numeric prefixed files will be
 * evaluated in increasing order. Services will be started and environment
 * injected.
 *
 * @param dir - the path to the service directory to parse
 * @return -1 on error, 0 on success
 */
int SERVICE_ScanSrvDir(const char *dir);

/**
 * Initialize service array
 */
void SERVICE_InitSrvList(void);

/**
 * Reset watchdog counter for service in our list
 *
 * @param pid PID of the service to reset watchdog counter for
 */
void SERVICE_ResetSrvWatchdog(int pid);

/**
 * Check if at least one service has expired watchdog timer
 *
 * @return 1 if a watchdog counter has expired, 0 otherwise
 */
int SERVICE_ChkExpiredWatchdog(void);

/**
 * Count down all running watchdog timers
 */
void SERVICE_CountDownWatchdogs(void);

/**
 * Remove service entry from our list
 *
 * @param pid PID of service to remove
 * @return 1 if PID found and removed, 0 otherwise
 */
int SERVICE_RemoveSrv(pid_t pid);

/**
 * Add grand child service to our list
 *
 * @param pid PID to add
 * @param wdsec Watchdog seconds
 * @param type Service type (e.g. "notify")
 * @return Zero if adding was unsuccessful. Return 1 if successful. Return
 *         negative on error
 */
int SERVICE_AddSrv(int pid, unsigned int wdsec, const char *type);

/**
 * Check type of service
 *
 * @param pid PID to search for
 * @param type Type to search for
 * @return 0 if PID not found or doesn't match with type. 1 otherwise
 */
int SERVICE_ChkSrvType(pid_t pid, const char *type);

/**
 * Check if service is on watchdog timer
 *
 * @param pid PID to search for
 * @return 1 if PID is found and has a watchdog value, 0 otherwise
 */
int SERVICE_ChkSrvWatchdog(pid_t pid);

/**
 * Check if we take action when a service died
 *
 * @param  pid  Pid of service to check
 * @return  Positive if we take action when service has died, zero otherwise
 */
int SERVICE_ChkSrvDiedAction(pid_t pid);

/**
 * READY=1 was received from a PID
 *
 * @param  pid  Pid of service
 *
 */
void SERVICE_ReadyReceived(pid_t pid);

/**
 * Check if at least one service has not yet sent READY=1
 *
 * @return 1 if we have outstanding READY=1, 0 otherwise
 */
int SERVICE_ChkWaitNotify(void);

#ifdef __cplusplus
}
#endif

#endif
