#include <sys/types.h>

#include "isoinit.h"
#include "lcm_defines.h"
#include "service.h"

extern char *dltid;
LCM_IMPORT_CONTEXT(IINI_MAIN)

int main(int argc, char *argv[])
{
    ISOINIT_SetupDebug();

#if 0
    if (ISOINIT_Daemonize() < 0)
    {
        return -1;
    }
#endif

    /* check all given cmdline args */
    if (ISOINIT_CheckArgs(argc, argv) < 0)
    {
        return -1;
    }

    ISOINIT_InstallSignalHandler();

    LCM_REGISTER_APP(dltid, "Isoinit Isolation manager");
    /* register context */
    LCM_REGISTER_CONTEXT(IINI_MAIN, "INI1", "Isoinit main CTX");
    DEBUG_TRACE_LEV((IINI_MAIN, DBG_INFO, "Isoinit Isolation manager running\n"));

    SERVICE_InitSrvList();

    ISOINIT_BuildSocketPaths();
    ISOINIT_PrintCredentials();

    if (ISOINIT_ChangeUser() < 0)
    {
        DEBUG_TRACE_LEV((IINI_MAIN, DBG_FATAL, "Failed changing user, exiting!\n"));
        return -1;
    }

    ISOINIT_PrintCredentials();

    /* Last chance to change the internal socket */
    ISOINIT_SetSocketPath();

    if (ISOINIT_SetupSocket() < 0)
    {
        return -1;
    }

    char *path = ISOINIT_GetSocketPath();
    SERVICE_SetIsoinitSockPath(path);

    if (ISOINIT_ScanSrvDir() < 0)
    {
        return -1;
    }

    return ISOINIT_MainLoop();
}
