/*****************************************************************************
 * FILE 		: fc_tclSTCDbusStub.cpp
 *
 * BRIEF		: Hand-crafted code
 *
 * SW-COMPONENT : fc_stc DBus Stub
 *
 * DESCRIPTION 	: This class provides the interface for sending/receiving data 
*                 to/from DBus Server
 *
 * AUTHOR 		: Arjun Kumar R L (RBEI/ECP4)
 *
 *
 * COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
 *
 * HISTORY:  
   Date			 | Author			        | Modification
   01.02.2016	 | Arjun Kumar R L			| Initial Version
 ***************************************************************************/
#include "../include/fc_tclSTCDbusStub.h"
#include "dlt/dlt.h"

DLT_DECLARE_CONTEXT(STC_STUB)

using namespace std;

fc_tclSTCDbusStub* fc_tclSTCDbusStub::m_pofc_tclSTCDbusStub = NULL;

/*********************************************************************
 * Function       : fc_tclSTCDbusStub()
 * Description    : Constructor
 * Parameters     : DBus::Connection& , DBus::ObjectAdaptor
 * Return value   : NA
 * History        : Date		| Author				| Modification
 *  				01.02.2016  | ARJUN KUMAR R L       | initial version
 *************************************************************************/
fc_tclSTCDbusStub::fc_tclSTCDbusStub():StcservicesStub("FCSTCStubPort")
{
	DLT_REGISTER_CONTEXT(STC_STUB,"STUB","Registration of FCSTC STUB");
	//cout<<"fc_tclSTCDbusStub()...Constructor"<<endl;
	m_pofc_tclSTCDbusStub = this;
	m_pofc_tclSTC_PDDInstance = NULL;
	m_pofc_tclSTC_CSMCallbackHandler = NULL;
	m_poFc_tclGNSsensorCCAClientHandler = NULL;
	m_ActualSecureTime = 0;
	m_pofc_tclSTC_PDDInstance = fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance();
	if(m_pofc_tclSTC_PDDInstance)
	{
		m_ActualSecureTime = (m_pofc_tclSTC_PDDInstance->ReturnLastSavedSecuretime()); //Assigning default value if m_pofc_tclSTC_PDDInstance is created
		//cout<<"m_ActualSecureTime = "<<m_ActualSecureTime<<endl;
	}


}

/**********************************************************************
 * Function       : ~fc_tclSTCDbusStub()
 * Description    : Destructor
 * Parameters     : None
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
fc_tclSTCDbusStub::~fc_tclSTCDbusStub()
{
	DLT_UNREGISTER_CONTEXT(STC_STUB);
	if(m_poFc_tclGNSsensorCCAClientHandler != NULL)
	{
		m_poFc_tclGNSsensorCCAClientHandler = NULL;
	}
	if(m_pofc_tclSTC_CSMCallbackHandler != NULL)
	{
		m_pofc_tclSTC_CSMCallbackHandler = NULL;
	}
	if(m_pofc_tclSTC_PDDInstance != NULL)
	{
		m_pofc_tclSTC_PDDInstance = NULL;
	}
	
	//cout<<"~fc_tclSTCDbusStub()...Destructor"<<endl;
	
}

/**********************************************************************
 * Function       : poGetFC_tclHostapdClientInstance
 * Description    : Method to return self referential Stub pointer
 * Parameters     : None
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version			    		 			
 **********************************************************************/
fc_tclSTCDbusStub* fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance()
{
	
	//cout<< "m_poGetfc_tclSTCDbusStubInstance()" <<endl;
	if(NULL != m_pofc_tclSTCDbusStub)
	{
		return m_pofc_tclSTCDbusStub;
	}
	else
		return NULL;
}

/**********************************************************************
 * Function       : onGetTimeRequest
 * Description    : Method to be called by clients to get the secure-time (epoch time is sent in its response)
 * Parameters     : None
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version			    		 			
 **********************************************************************/
void fc_tclSTCDbusStub::onGetTimeRequest (const ::boost::shared_ptr< GetTimeRequest >& request)
{
	(void)request;
	//cout<< "onGetTimeRequest()" <<endl;
	tU64 ResponseTime = 0;// for lint warning
	bool GPSstatus = false;
	m_poFc_tclGNSsensorCCAClientHandler = Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler();
	if(m_poFc_tclGNSsensorCCAClientHandler)
	{
		GPSstatus = m_poFc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
		//cout <<"GPSstatus is present = "<<GPSstatus<<endl;
	}
	if(GPSstatus == false)
	{
		m_pofc_tclSTC_CSMCallbackHandler = fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance();
		if(m_pofc_tclSTC_CSMCallbackHandler)
		{
			//cout<<"m_ActualSecureTime = "<<m_ActualSecureTime<<endl;
			//cout<<"m_pofc_tclSTC_CSMCallbackHandler->u32ReturnCPTTickCounter() = "<<m_pofc_tclSTC_CSMCallbackHandler->u32ReturnCPTTickCounter()<<endl;
			ResponseTime = (m_pofc_tclSTC_CSMCallbackHandler->u32ReturnCPTTickCounter()) + (m_ActualSecureTime);
			//cout<< "ResponseTime = " <<ResponseTime<<endl;
		}
	}
	else
	{
		if(m_poFc_tclGNSsensorCCAClientHandler)
		{
			//cout<<"m_ActualSecureTime = "<<m_ActualSecureTime<<endl;
			//cout<<"m_poFc_tclGNSsensorCCAClientHandler->u64ReturnGPSTickCounter() = "<<m_poFc_tclGNSsensorCCAClientHandler->u64ReturnGPSTickCounter()<<endl;
			ResponseTime = (m_poFc_tclGNSsensorCCAClientHandler->u64ReturnGPSTickCounter()) + (m_ActualSecureTime);
		}

	}

	DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO] Sending GetTime: "),DLT_UINT64(ResponseTime));
	sendGetTimeResponse(ResponseTime);

}

/**********************************************************************
 * Function       : onSetTimeRequest
 * Description    : Method to be called by ECM only to set time
 * Parameters     : ::boost::shared_ptr< SetTimeRequest >& request 
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version			    		 			
 **********************************************************************/
void fc_tclSTCDbusStub::onSetTimeRequest (const ::boost::shared_ptr< SetTimeRequest >& request)
{
	DLT_LOG_STRING(STC_STUB, DLT_LOG_INFO, ("SetTime"));
	m_pofc_tclSTC_CSMCallbackHandler = fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance();
	
	if(m_pofc_tclSTC_CSMCallbackHandler)
	{
		if(true == m_pofc_tclSTC_CSMCallbackHandler->bReturnShutDownCAL())
		{
			//cout<< "onSetTimeRequest()" <<endl;
			tU64 ReceivedSetTime = request->getValue();
			DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]SetTime Received: "),DLT_UINT64(ReceivedSetTime));
			//cout<< "ReceivedSetTime = " <<ReceivedSetTime<<endl;
			bool GPSstatus = false;
			m_poFc_tclGNSsensorCCAClientHandler = Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler();
			if(m_poFc_tclGNSsensorCCAClientHandler)
			{
				GPSstatus = m_poFc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
				//cout <<"GPSstatus is present = "<<GPSstatus<<endl;
			}
			tU64 CurrentSecuretime = 0;//Lint Warning
			CurrentSecuretime = (m_pofc_tclSTC_CSMCallbackHandler->u32ReturnCPTTickCounter()) + (m_ActualSecureTime);
			//cout<< "CurrentSecuretime = " <<CurrentSecuretime<<endl;
			if((ReceivedSetTime > CurrentSecuretime) && (GPSstatus == false))
			{
				m_ActualSecureTime = ReceivedSetTime;
				DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]SetTime Successful: "),DLT_UINT64(ReceivedSetTime));
				//cout<< "SetTime successfull" <<endl;
				m_pofc_tclSTC_CSMCallbackHandler->vResetTickCounter();
				m_pofc_tclSTC_CSMCallbackHandler->vSaveCPTandSecureTimeOnShutdown(GPSstatus,0); //Immediately saving once received
			}
		}
	
	}
	sendSetTimeResponse(request->getAct());

}

/**********************************************************************
 * Function       : onProvideCEAtimeRequest
 * Description    : Method to be called by ECM only
 * Parameters     : ::boost::shared_ptr< ProvideCEAtimeRequest >& request
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
void fc_tclSTCDbusStub::onProvideCEAtimeRequest(const ::boost::shared_ptr< ProvideCEAtimeRequest >& request)
{
	DLT_LOG_STRING(STC_STUB, DLT_LOG_INFO, ("ProvideCEAtime"));
	m_pofc_tclSTC_CSMCallbackHandler = fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance();
	if(m_pofc_tclSTC_CSMCallbackHandler)
	{
		if(true == m_pofc_tclSTC_CSMCallbackHandler->bReturnShutDownCAL())
		{
			//cout<< "onProvideCEAtimeRequest()" <<endl;
			tU64 ReceivedSetTime = request->getValue();
			DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]ProvideCEAtime received: "),DLT_UINT64(ReceivedSetTime));
			//cout<< "ReceivedSetTime = " <<ReceivedSetTime<<endl;
			bool GPSstatus = false;
			m_poFc_tclGNSsensorCCAClientHandler = Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler();
			if(m_poFc_tclGNSsensorCCAClientHandler)
			{
				GPSstatus = m_poFc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
				//cout <<"GPSstatus is present = "<<GPSstatus<<endl;
			}
			if(GPSstatus == false)
			{
				m_ActualSecureTime = ReceivedSetTime;
				DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]ProvideCEAtime Successful: "),DLT_UINT64(ReceivedSetTime));
				//cout<< "ProvideCEAtime successfull" <<endl;
				m_pofc_tclSTC_CSMCallbackHandler->vResetTickCounter();
				m_pofc_tclSTC_CSMCallbackHandler->vSaveCPTandSecureTimeOnShutdown(GPSstatus,0); //Immediately saving once received				
			}
		}
	}
	sendProvideCEAtimeResponse(request->getAct());
}

/**********************************************************************
 * Function       : onSetCEATokenTimeRequest
 * Description    : Method to be called by CEA only
 * Parameters     : ::boost::shared_ptr< SetCEATokenTimeRequest >& request
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
void fc_tclSTCDbusStub::onSetCEATokenTimeRequest (const ::boost::shared_ptr< SetCEATokenTimeRequest >& request)
{
	DLT_LOG_STRING(STC_STUB, DLT_LOG_INFO, ("SetCEATokenTime"));
	m_pofc_tclSTC_CSMCallbackHandler = fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance();
	if(m_pofc_tclSTC_CSMCallbackHandler)
	{
		if(true == m_pofc_tclSTC_CSMCallbackHandler->bReturnShutDownCAL())
		{
			//cout<< "onSetCEATokenTimeRequest()" <<endl;
			tU64 ReceivedSetTime = request->getValue();
			DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]SetCEATokentime Received: "),DLT_UINT64(ReceivedSetTime));
			//cout<< "ReceivedSetTime = " <<ReceivedSetTime<<endl;
			bool GPSstatus = false;
			m_poFc_tclGNSsensorCCAClientHandler = Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler();
			if(m_poFc_tclGNSsensorCCAClientHandler)
			{
				GPSstatus = m_poFc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
				//cout <<"GPSstatus is present = "<<GPSstatus<<endl;
			}
			tU64 CurrentSecuretime = 0;//Lint Warning			
			CurrentSecuretime = (m_pofc_tclSTC_CSMCallbackHandler->u32ReturnCPTTickCounter()) + (m_ActualSecureTime);
			//cout<< "CurrentSecuretime = " <<CurrentSecuretime<<endl;
			if((ReceivedSetTime > CurrentSecuretime) && (GPSstatus == false))
			{
				m_ActualSecureTime = ReceivedSetTime;
				DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]SetCEATokentime Successful: "),DLT_UINT64(ReceivedSetTime));
				//cout<< "onSetCEATokenTimeRequest successfull" <<endl;	
				m_pofc_tclSTC_CSMCallbackHandler->vResetTickCounter();
				m_pofc_tclSTC_CSMCallbackHandler->vSaveCPTandSecureTimeOnShutdown(GPSstatus,0); //Immediately saving once received
			}
		}
	
	}
	sendSetCEATokenTimeResponse(request->getAct());
}
/**********************************************************************
 * Function       : vSendCPTdifference
 * Description    : To add shutdown time to last read time.
 * Parameters     : unsigned long DeltaCPT
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version			    		 			
 **********************************************************************/
void fc_tclSTCDbusStub::vSendCPTdifference (tU64 DeltaCPT)
{
	//cout<< "vSendCPTdifference() received from CSM : DeltaCPT = " <<DeltaCPT<<endl;
	bool GPSstatus = false;
	m_poFc_tclGNSsensorCCAClientHandler = Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler();
	if(m_poFc_tclGNSsensorCCAClientHandler)
	{
		GPSstatus = m_poFc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
		//cout <<"GPSstatus is present = "<<GPSstatus<<endl;
	}
	if(GPSstatus == false)  //If GPS is not updated the --> Then update
	{
		m_pofc_tclSTC_PDDInstance = fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance();
		if(m_pofc_tclSTC_PDDInstance)
		{
			m_ActualSecureTime = (m_pofc_tclSTC_PDDInstance->ReturnLastSavedSecuretime())+(DeltaCPT);
			//cout<< "m_ActualSecureTime after adding DeltaCPT = " <<m_ActualSecureTime<<endl;
			DLT_LOG(STC_STUB, DLT_LOG_INFO,DLT_STRING("[INFO]After Adding CPT_diff SecureTime: "),DLT_UINT64(m_ActualSecureTime));
		}
	}

}

/**********************************************************************
 * Function       : vSetSecureTime
 * Description    : Assigns the Latest time and Resets the CPT ticks
 * Parameters     : unsigned long DeltaCPT
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/

void fc_tclSTCDbusStub::vSetSecureTime(tU64 SetTime)
{
	    //cout<<"vSetSecureTime = "<<SetTime<<endl;
		m_ActualSecureTime = SetTime;
		//cout<<"m_ActualSecureTime = "<<m_ActualSecureTime<<endl;
		//Also Reset the CPT tick counter
		m_pofc_tclSTC_CSMCallbackHandler = fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance();
		if(m_pofc_tclSTC_CSMCallbackHandler)
		{
			m_pofc_tclSTC_CSMCallbackHandler->vResetTickCounter();
		}

}


/**********************************************************************
 * Function       : u64ReturnActualSecureTime
 * Description    : To return m_ActualSecureTime
 * Parameters     : NA
 * Return value   : tU64
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
tU64 fc_tclSTCDbusStub::u64ReturnActualSecureTime()
{
	return m_ActualSecureTime;
}

//End Of File

