/*****************************************************************************
 * FILE 		: Fc_tclGNSsensorCCAClientHandler.cpp
 *
 * BRIEF		: Hand-crafted code
 *
 * SW-COMPONENT : fc_stc DBus Stub
 *
 * DESCRIPTION 	: This class provides the interface for sending/receiving data 
*                 to/from DBus Server
 *
 * AUTHOR 		: Arjun Kumar R L (RBEI/ECP4)
 *
 *
 * COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
 *
 * HISTORY: 
   Date			 | Author			        | Modification
   01.02.2016	 | Arjun Kumar R L			| Initial Version
 ***************************************************************************/
#include "../include/Fc_tclGNSsensorCCAClientHandler.h"
#include "dlt/dlt.h"

DLT_DECLARE_CONTEXT(STC_GNS)
using namespace std;

Fc_tclGNSsensorCCAClientHandler* Fc_tclGNSsensorCCAClientHandler::m_poFc_tclGNSsensorCCAClientHandler = NULL;

/*********************************************************************
 * Function       : Fc_tclGNSsensorCCAClientHandler()
 * Description    : Constructor
 * Parameters     : DBus::Connection& , DBus::ObjectAdaptor
 * Return value   : NA
 * History        : Date		| Author				| Modification
 *  				01.02.2016  | ARJUN KUMAR R L       | initial version
 *************************************************************************/
Fc_tclGNSsensorCCAClientHandler::Fc_tclGNSsensorCCAClientHandler():_sensorccaproxy(Sensor_location_fiProxy::createProxy("GNSPort",*this))
{
	DLT_REGISTER_CONTEXT(STC_GNS,"GNS0","Registration of FCSTC GNS");
	//cout<<"Fc_tclGNSsensorCCAClientHandler()...Constructor"<<endl;
	m_poFc_tclGNSsensorCCAClientHandler = this;
	bGPSUPDATEStatus = false;
	mGPSTickCounter = 0;
	m_poGetfc_tclSTCDbusStub = NULL;

}

/**********************************************************************
 * Function       : ~Fc_tclGNSsensorCCAClientHandler()
 * Description    : Destructor
 * Parameters     : None
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
Fc_tclGNSsensorCCAClientHandler::~Fc_tclGNSsensorCCAClientHandler()
{
	DLT_UNREGISTER_CONTEXT(STC_GNS);
	if(m_poGetfc_tclSTCDbusStub != NULL)
	{
		m_poGetfc_tclSTCDbusStub = NULL;
	}
	//cout<<"~Fc_tclGNSsensorCCAClientHandler()...Destructor"<<endl;
	
}

/**********************************************************************
 * Function       : poGetFC_tclHostapdClientInstance
 * Description    : Method to return self referential Stub pointer
 * Parameters     : None
 * Return value   : NA
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version			    		 			
 **********************************************************************/
Fc_tclGNSsensorCCAClientHandler* Fc_tclGNSsensorCCAClientHandler::poGetFc_tclGNSsensorCCAClientHandler()
{
	
	//cout<< "poGetFc_tclGNSsensorCCAClientHandler()" <<endl;
	if(NULL != m_poFc_tclGNSsensorCCAClientHandler)
	{
		return m_poFc_tclGNSsensorCCAClientHandler;
	}
	else
		return NULL;
}
/*************************************************************************
 *
 * FUNCTION: onAvailable(const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange)
 *
 * DESCRIPTION: This function indicates the ASF based CCA proxy is connected with SPM Services successfully  ,
 *
 * PARAMETER: const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
void Fc_tclGNSsensorCCAClientHandler::onAvailable(const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange)
{
	(void)proxy;
	(void)stateChange;
	//cout<<"Fc_tclGNSsensorCCAClientHandler::onAvailable"<<endl; // This fuction will not be called on A1 variant
	if(_sensorccaproxy)
	{
		_sensorccaproxy->sendGnssDataUpReg(*this);
		_sensorccaproxy->sendGnssDataGet(*this);
		//cout<<"Fc_tclGNSsensorCCAClientHandler:Registering for property"<<endl;
	}
}

/*************************************************************************
 *
 * FUNCTION: onUnavailable(const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange)
 *
 * DESCRIPTION: This function indicates the ASF based CCA proxy is disconnected with SPM Services successfully  ,
 *
 * PARAMETER: const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
void Fc_tclGNSsensorCCAClientHandler::onUnavailable(const::boost::shared_ptr<asf::core::Proxy> &proxy, const ServiceStateChange &stateChange)
{
	//cout<<"Fc_tclGNSsensorCCAClientHandler:onUnavailable"<<endl;
	(void)proxy;
    (void)stateChange;
    if(_sensorccaproxy)
    	_sensorccaproxy->sendGnssDataRelUpRegAll();

}

/*************************************************************************
 *
 * FUNCTION: onGnssDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error)
 *
 * DESCRIPTION: This function used to get the GNSS ,
 *
 * PARAMETER: const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
void Fc_tclGNSsensorCCAClientHandler::onGnssDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error)
{
	//cout<<"Fc_tclGNSsensorCCAClientHandler:onGnssDataError"<<endl;
	(void)proxy;
	(void)error;
	//cout<<"error "<<error<<endl;
}

/*************************************************************************
 *
 * FUNCTION: onGnssDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error)
 *
 * DESCRIPTION: This function used to get the GNSS ,
 *
 * PARAMETER: const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
void Fc_tclGNSsensorCCAClientHandler::onGnssDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataStatus >& status)
{
	(void)proxy;
	//cout<<"Fc_tclGNSsensorCCAClientHandler:onGnssDataStatus"<<endl;
	T_GnssData GnssData = status->getGnssData();
	T_GnssPvtData GnssPvtData=GnssData.getGnssPvtData();
	//T_GnssStatus GnssStatus=GnssPvtData.getGnssStatus();
	//T_e8_GnssMode GnssMode=GnssStatus.getGnssMode();
	T_TimeDate TimeDate=GnssPvtData.getUtcTimeDate();
	tU16 u16Year = TimeDate.getTd_year ();
	tU16 u16Month = TimeDate.getTd_month();
	tU16 u16Day = TimeDate.getTd_day();
	tU16 u16Hour = TimeDate.getTd_hour();
	tU16 u16Min = TimeDate.getTd_minute();
	tU16 u16Second = TimeDate.getTd_second();

	//cout<<"Date : "<<u16Day<<" "<<u16Month<<" "<<u16Year<<endl;
	//cout<<"Time : "<<u16Hour<<" "<<u16Min<<" "<<u16Second<<endl;
	mGPSTickCounter = mGPSTickCounter + 1;

	tU64 seconds = 0;
    if(bGPSUPDATEStatus == false)
    {
    	if((u16Year >2016) && (u16Year < 2038))
    	{

    		struct tm tm_info;
    		tm_info.tm_year = (u16Year - 1900);
    		tm_info.tm_mon  = (u16Month - 1);
    		tm_info.tm_mday = u16Day;
    		tm_info.tm_hour = u16Hour;
    		tm_info.tm_min  = u16Min;
    		tm_info.tm_sec  = u16Second;
    		tm_info.tm_isdst= 0;

    		time_t GPS_time  = mktime(&tm_info);
    		//cout<<"GPS_time = "<<GPS_time<<endl;
			tU32 GPS_value = (tU32)GPS_time;
			//cout<<"GPS_value = "<<GPS_value<<endl;
    		seconds = (tU64)GPS_value;
    		//cout<<"seconds = "<<seconds<<endl;
    		m_poGetfc_tclSTCDbusStub = fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance();
    		if(m_poGetfc_tclSTCDbusStub)
    		{
    			m_poGetfc_tclSTCDbusStub->vSetSecureTime(seconds);
    		}

    		bGPSUPDATEStatus = true;
    		mGPSTickCounter = 0;
			DLT_LOG(STC_GNS, DLT_LOG_INFO,DLT_STRING("[INFO]GPS value received  : "),DLT_UINT64(seconds));
    	}
    	else if((u16Year >2037) && (u16Year < 2125))
    	{
    		tU16 arrmonth[12] = {31,59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    		tU64 i, leap_days = 17, number_days = 0;

    		for(i=2037; i<u16Year; i++) //time set to connman is from epoch
    		{
    			if(IS_LEAP_YEAR(i))
    			{
    			  leap_days++;
    			}
    		}
    		//cout <<"number of days initial " <<number_days<<endl;
    		//cout<<"leap day is"<<leap_days <<endl;
    		number_days = (365*(u16Year - 1970)) + leap_days;
    		//cout<<"total number of days in years from 1970 is" <<number_days <<endl;

    		/************************** month ************************************/
    		if((u16Month >1)) //count only if not January
    		{
    		  number_days = number_days + arrmonth[u16Month-2];
    		  if((u16Month >2) && (IS_LEAP_YEAR(u16Year))) //month is greater than feb and is a leap year add another day
    			  number_days = number_days + 1;
    		 // cout<<"total number of days in years plus months from 1970 is" <<number_days <<endl;
    		}
    		number_days = number_days + (u16Day - 1);

    		seconds = (number_days * 24 * 3600) + (u16Hour * 3600 ) + ( u16Min * 60) + u16Second; //number_days * 24 * 3600 crossing range i.e why tU64--> int * int = int
    		//cout<<"seconds = "<<seconds<<endl;
    		m_poGetfc_tclSTCDbusStub = fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance();
    		if(m_poGetfc_tclSTCDbusStub)
    		{
    			m_poGetfc_tclSTCDbusStub->vSetSecureTime(seconds);
    		}

    		bGPSUPDATEStatus = true;
    		mGPSTickCounter = 0;
			DLT_LOG(STC_GNS, DLT_LOG_INFO,DLT_STRING("[INFO]GPS value received  : "),DLT_UINT64(seconds));
    	}
    }



}

/*************************************************************************
 *
 * FUNCTION: bReturnGPSUPDATEStatus
 *
 * DESCRIPTION: This function returns ,
 *
 * PARAMETER: NA
 *
 * RETURNVALUE: bool
 *
 *************************************************************************/
bool Fc_tclGNSsensorCCAClientHandler::bReturnGPSUPDATEStatus()
{
	return bGPSUPDATEStatus;
}

/*************************************************************************
 *
 * FUNCTION: u64ReturnGPSTickCounter
 *
 * DESCRIPTION: This function returns ,
 *
 * PARAMETER: NA
 *
 * RETURNVALUE: bool
 *
 *************************************************************************/
tU64 Fc_tclGNSsensorCCAClientHandler::u64ReturnGPSTickCounter()
{
	tU64 Tickvalue = (tU64)mGPSTickCounter;
	return Tickvalue;
}

//End Of File

