/************************************************************************
 * FILE:         fc_tclSTC_PDD.h
 * PROJECT:      PSA-RCC
 * SW-COMPONENT: FC_STC
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: This file contains definition of PDD class
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author		                   		  		| Modification
 * 01.01.17  | RBEI/ECP4 ARJUN KUMAR R L   | initial version
 *************************************************************************/

#ifndef FC_TCLSTC_PDD_H_
#define FC_TCLSTC_PDD_H_

#define CHECK_LEAP_YEAR(Y)     ( ((Y)>0) && !((Y)%4) && ( ((Y)%100) || !((Y)%400) ) )
#include "fc_tclSTC_CSMCallbackHandler.h"
#include "Fc_tclGNSsensorCCAClientHandler.h"
#include "fc_tclSTCDbusStub.h"
#define SW_VERSION_DATE                            "/opt/bosch/cc_main.txt"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_e01b_if.h"
#include <iostream>
#include <time.h>

using namespace std;

class fc_tclSTC_PDD
{

public:

	fc_tclSTC_PDD();  //constructor
	
	
	virtual ~fc_tclSTC_PDD(); //destructor

	
	static fc_tclSTC_PDD * m_poGetm_pofc_tclSTC_PDDInstance();
	
	tU64 ReturnLastSavedCPTtime();
	
	tU64 ReturnLastSavedSecuretime();
	
	void vSaveCPTandSECUREtime(tU64 SECUREShutdown, tU64 CPTShutdown);
	void vGetBuiltime();
	
private:

	tU64 m_CPTtime;
	tU64 m_SECURETime;
	tU64 m_buildTime;
	dp_tclFC_STCDPSECURE_TIME m_dp_tclFC_STCDPSECURE_TIME;
	dp_tclFC_STCDPCPT_TEMPOREL_TIME m_dp_tclFC_STCDPCPT_TEMPOREL_TIME;
	static fc_tclSTC_PDD * m_pofc_tclSTC_PDD;
};


#endif 

/* end of file */
