/************************************************************************
 * FILE:         fc_tclSTC_CSMCallbackHandler.h
 * PROJECT:      PSA-RCC
 * SW-COMPONENT: fc_STC
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: This file contains the declaration of the class
 *     fc_tclVehicleFuncMaster_CSMCallbackHandler
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author		                   		  | Modification
 * 14.11.14  | RBEI/ECP4 ARJUN KUMAR R L              | initial version

 *************************************************************************/
#ifndef FC_TCLSTC_CSMCALLBACKHANDLER_H
#define FC_TCLSTC_CSMCALLBACKHANDLER_H

//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

#include "Fc_tclGNSsensorCCAClientHandler.h"
#include "fc_tclSTCDbusStub.h"
#include "fc_tclSTC_PDD.h"
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#define MAX_CPTTEMPOREL_DIFFERENCE   4000000 // 4000000 ~ 46.29 days      
#include "csm_if.h"
#include <map>
#include <iostream>
#include <time.h>
#include <fstream>
#include <string>
using namespace std;

class fc_tclSTCDbusStub;
class fc_tclSTC_PDD;

class fc_tclSTC_CSMCallbackHandler
{
private:
	//CSMInterface* pCSMInterface;
	csm_tclCsmAccessUser* pCsmAccessUser;
	
	bool bUpdateStatus;
	
	tU32 m_TickCounter;
	
	tU32 m_CPTValue;
	
	static tU32 m_PrevCPT;

	fc_tclSTCDbusStub* m_pogetfc_tclSTCDbusStub;
	
	static fc_tclSTC_CSMCallbackHandler* m_pSTCCSMCallBackHandler;
public:
	
	fc_tclSTC_CSMCallbackHandler();
	~fc_tclSTC_CSMCallbackHandler();

	static fc_tclSTC_CSMCallbackHandler* poGetfc_tclSTC_CSMCallbackHandlerInstance();
	
	tU64 u32ReturnCPTTickCounter();
	void vSaveCPTandSecureTimeOnShutdown(bool GPSstatus, tU64 GpsTick);
	//Function which starts the communication with CSM
	bool bStartCSMCommunication();

	//Function to close the CSM communication
	void vCloseCSMCommunication();

	//Function which manages the registration for BC signals
	bool bRegisterForBroadCastSignals();

	//Function to get the CSM access handle
	bool bGetCSMHandler();

	//Function to get the CSM access handle obj
    csm_tclCsmAccessUser *objGetCSMAccessUser();
	
	//Function used to register for the one signal
	bool bRegisterForBrSignal(tS32 s32SigID);

	void vGetCSMdata();
	
	//To monitor only once System time is updated.
	
	void vInitialiseSecureTime(tU32 Time);
	
	void vIncrementCSMCounter();
	
	void vResetTickCounter();
	
	fc_tclSTC_PDD * m_pogetSTCPDD;
	
	bool bReturnShutDownCAL();

	//Fucntion which manages the callbacks for broacast signals
	static void vCSMSignalCallback( void *pvHandle, tU32 u32SignalID, tU32 u32SignalState );

};


#endif 
