/************************************************************************
 * FILE:         fc_tclSTCDbusStub.h
 * PROJECT:      PSA-RCC
 * SW-COMPONENT: FC_STC
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: This file contains definition of PDD class
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author		                   		  		| Modification
 * 01.01.17  | RBEI/ECP4 ARJUN KUMAR R L   | initial version
 *************************************************************************/

#ifndef FC_TCLSTCDBUSSTUB_H_
#define FC_TCLSTCDBUSSTUB_H_

#include <iostream>
#include "org/bosch/stc/stcservicesStub.h"
#include "fc_tclSTC_PDD.h"
#include "fc_tclSTC_CSMCallbackHandler.h"
#include "Fc_tclGNSsensorCCAClientHandler.h"


#define HOSTAPD_STUB_SERVICE "FCSTCStubPort"

using namespace std;
using namespace ::asf::core;
using namespace ::org::bosch::stc::stcservices;

using namespace std;
class fc_tclSTC_PDD;
class fc_tclSTC_CSMCallbackHandler;
class Fc_tclGNSsensorCCAClientHandler;

class fc_tclSTCDbusStub : public StcservicesStub
{

public:

	fc_tclSTCDbusStub();  //constructor
	
	
	virtual ~fc_tclSTCDbusStub(); //destructor

	
	static fc_tclSTCDbusStub * m_poGetfc_tclSTCDbusStubInstance();
	
	void onGetTimeRequest (const ::boost::shared_ptr< GetTimeRequest >& request);
	
	void onSetTimeRequest (const ::boost::shared_ptr< SetTimeRequest >& request);
	
	void onProvideCEAtimeRequest (const ::boost::shared_ptr< ProvideCEAtimeRequest >& request);
	
	void onSetCEATokenTimeRequest (const ::boost::shared_ptr< SetCEATokenTimeRequest >& request);

	void vSendCPTdifference(tU64);

	void vSetSecureTime(tU64 SetTime);

	tU64 u64ReturnActualSecureTime();

	
private:

	static fc_tclSTCDbusStub * m_pofc_tclSTCDbusStub;
	
	fc_tclSTC_PDD* m_pofc_tclSTC_PDDInstance;
	
	fc_tclSTC_CSMCallbackHandler* m_pofc_tclSTC_CSMCallbackHandler;
	
	Fc_tclGNSsensorCCAClientHandler* m_poFc_tclGNSsensorCCAClientHandler;

	tU64 m_ActualSecureTime;
};


#endif 

/* end of file */
