/*****************************************************************************
* FILE 			: FC_STCMain.cpp
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: ASF Connectivity component
*
* DESCRIPTION 	: Main Component class which implements LCM interfaces and Initializes other stub and proxy classes
*				  
* AUTHOR 		: Arjun Kumar R L (RBEI/ECP4)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY: 
   Date			 | Author			        | Modification
   01.02.2016	 | Arjun Kumar R L			| Initial Version			  
****************************************************************************/
#include "FC_STCMain.h"
#include "dlt/dlt.h"

#define DLT_FCSTC_APP "STC0"
DLT_DECLARE_CONTEXT(STC_MAIN)

using namespace std;
using namespace ::asf::core;

// Using the namespaces of lcm component

using namespace std;

namespace FC_STC{

/****************************************************************************
 Function       : Constructor
 Description    : Constructor
 Parameters     : None
 Return Value   : None
 HISTORY:
   Date			 | Author			        | Modification
   01.02.16		 | Arjun Kumar R L			| initial version
 ***************************************************************************/
FC_STCMain::FC_STCMain():BaseComponent()//,_lcmAppComponent( "FC_STC.FC_STCApp","/org/genivi/NodeStateManager/LifeCycleConsumer/fc_stc",*this)
{
	DLT_REGISTER_APP(DLT_FCSTC_APP, "FC_STC application for logging");
	DLT_REGISTER_CONTEXT(STC_MAIN,"MAIN","Registration of FCSTC MAIN");
	DLT_LOG_STRING(STC_MAIN, DLT_LOG_INFO,("START-UP FC_STC"));
	m_fc_tclSTC_PDDHandler = new fc_tclSTC_PDD();
	m_Fc_tclGNSsensorCCAClientHandler = new Fc_tclGNSsensorCCAClientHandler();
	m_fc_tclSTCDbusStubHandler = new fc_tclSTCDbusStub();
	m_fc_tclSTC_CSMCallbackHandler = new fc_tclSTC_CSMCallbackHandler();
//	_lcmAppComponent.setAppStartReady();		
}

/****************************************************************************
 Function       : Destructor
 Description    : Destructor
 Parameters     : None
 Return Value   : None
 HISTORY:
  Date			 | Author			       | Modification
  01.02.16		 | Arjun Kumar R L		   | initial version
 ***************************************************************************/
FC_STCMain::~FC_STCMain()
{
	DLT_UNREGISTER_CONTEXT(STC_MAIN);
	if(NULL!= m_fc_tclSTC_PDDHandler)
    {	
        delete m_fc_tclSTC_PDDHandler;
        m_fc_tclSTC_PDDHandler = NULL;
    }
	if(NULL!= m_fc_tclSTC_CSMCallbackHandler)
    {	
        delete m_fc_tclSTC_CSMCallbackHandler;
        m_fc_tclSTC_CSMCallbackHandler = NULL;
    }
	if(NULL!= m_Fc_tclGNSsensorCCAClientHandler)
    {	
        delete m_Fc_tclGNSsensorCCAClientHandler;
        m_Fc_tclGNSsensorCCAClientHandler = NULL;
    }
	if(NULL!= m_fc_tclSTCDbusStubHandler)
    {	
        delete m_fc_tclSTCDbusStubHandler;
        m_fc_tclSTCDbusStubHandler = NULL;
    }

}

/*****************************************************************************
 * Function     :	OnAppModeChange
 *
 * Description  :	Called by spm on application state change
 *
 * Parameters   :	None
 *
 * Return Value :	None
 HISTORY:
 * Date			 | Author			       | Modification
 *01.02.16		 | Arjun Kumar R L		   | initial version
 *****************************************************************************/
/*_NsmErrorStatus_e FC_STCMain::OnAppModeChange(_Nsm_Shutdown_Type_e newAppMode, _Nsm_Shutdown_Type_e oldAppMode)
{
	_NsmErrorStatus_e returnVal = _NsmErrorStatus_e__NsmErrorStatus_NotSet;
	(void)oldAppMode;
	//ETG_TRACE_USR4(( "Fc_ConnectMain::OnAppModeChange()" ));   
	if(newAppMode == _Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Runup)
	{
      //goto Normal Mode
      returnVal = _NsmErrorStatus_e__NsmErrorStatus_Ok; // if successful
	}
	else if(newAppMode == _Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Normal)
	{
      // goto OFF Mode
		if(m_Fc_tclGNSsensorCCAClientHandler != NULL)
		{
			bool GPSstatus = false;
			GPSstatus = m_Fc_tclGNSsensorCCAClientHandler->bReturnGPSUPDATEStatus();
			tU64 GpsTick = m_Fc_tclGNSsensorCCAClientHandler->u64ReturnGPSTickCounter();

			if(m_fc_tclSTC_CSMCallbackHandler != NULL)
			{
				m_fc_tclSTC_CSMCallbackHandler->vSaveCPTandSecureTimeOnShutdown(GPSstatus,GpsTick);
			}

		}

		
      returnVal = _NsmErrorStatus_e__NsmErrorStatus_Ok; // if successful
	}

   return returnVal;
}
*/
/*****************************************************************************
 * Function     :	OnAppWatchdog
 *
 * Description  :	Function called on application watchdog
 *
 * Parameters   :	None
 *
 * Return Value :	None
 HISTORY:
 * Date			 | Author			       | Modification
 *01.02.16		 | Arjun Kumar R L		   | initial version
 *****************************************************************************/
bool FC_STCMain::OnAppWatchdog()
{
	bool bReturnVal = false;
//	ETG_TRACE_USR4(( "Fc_ConnectMain::OnAppWatchdog ..........." ));

	bReturnVal = true; // only if all is OK
	return bReturnVal;
}

/*****************************************************************************
 * Function     :	OnLcmRegistered
 *
 * Description  :	Called by spm application state change
 *
 * Parameters   :	None
 *
 * Return Value :	None
 HISTORY:
 * Date			 | Author			       | Modification
 *01.02.16		 | Arjun Kumar R L		   | initial version
 *****************************************************************************/
void FC_STCMain::OnLcmRegistered()
{   
  // ETG_TRACE_USR4(( "Fc_ConnectMain::OnLcmRegistered ..........." ));
}

/*****************************************************************************
 * Function     :	OnAvailable
 *
 * Description  :	This function is called by lcm component on availability of the service
 *
 * Parameters   :	None
 *
 * Return Value :	None
 HISTORY:
 * Date			 | Author			       | Modification
 *01.02.16		 | Arjun Kumar R L		   | initial version
 *****************************************************************************/
void FC_STCMain::OnAvailable()
{
   // ETG_TRACE_USR4(( "Fc_ConnectMain::OnAvailable ..........." ));	
	//_lcmAppComponent.setAppStartReady();
}
} //end of namespace

//End of File 
