/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        ecm_cm_tools.h

   \brief       Tools for the ECM CM Version

   ***

   $Rev: 937 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-20 16:27:46 +0100 (Mi, 20. Feb 2019) $
****************************************************************************/

#ifndef ECM_INC_ECM_CM_TOOLS_H_
#define ECM_INC_ECM_CM_TOOLS_H_

#include "esc_common.h"
#include "../../cmp/asn1-2005-multi-file-os-asn1c/CertificateList.h"
#include "crl_utils.h"
#include "ecm.h"
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/**
This function is used to cleanup ECM parameter structure

\param[in] ecm
    Pointer to ECM parameter structure
\param[in] conf
    Pointer to ECM configuration parameter structure

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure
*/
void ecmCmCleanup (
    ECM_PARAMS_t *ecm,
    ECM_CONFIG_t *conf );

/**
This function is used to initialize the ECM

\param[in] ecm
    ECM parameters structure (to be initialized)

\param[in] ecm_conf
    ECM Config parameters structure (to be initialized)

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure
*/
BOOL
cm_init(
    ECM_PARAMS_t* ecm,
    ECM_CONFIG_t* ecm_conf);

/**
This function is used to retrieve the UIN ToDo CM from the SDC

\param[in] ecm
    Pointer to global ECM structure

\retval UIN String - NULL on failure
*/
char* getUID(
    ECM_PARAMS_t *ecm );

/**
This function is used to load locally stored Certificate Revocation Lists

\param[in] path
    Path to folder with stored CRLs
\param[in] crList
    Pointer where revoked certificates shall be stored (if not NULL revoked
    certificates will be appended)
\param[in] hashes
    Pointer where hashes of loaded CRLs shall be stored


\return BOOL
\retval FALSE on success
\retval TRUE on failure

*/
BOOL
loadLocalCRLs(
    char* path,
    const CR_LIST_t** crList,
    CRL_HASHES_t** hashes);

/**
This function is used to delete all certificates in a given folder

\param[in] path
    Path to folder with stored Certificates

\return BOOL
\retval FALSE on success
\retval TRUE on failure

*/
BOOL
deleteCertsinFolder(
    char* path);

/**
This function is used to load the root certificate

\param[in] ecm
    ECM parameter structure

\return BOOL
\retval FALSE on success
\retval TRUE on failure

*/
BOOL
addRootCert(
    ECM_PARAMS_t* ecm);

/**
This function is used to remove invalid CLR hashes entries.
Invalid means outdated or invalid signature.

\param[in] ecm
    ECM parameter structure

\return BOOL
\retval FALSE on success
\retval TRUE on failure

*/
BOOL
removeInvalidCrlHashEntries (
    ECM_PARAMS_t *ecm );


BOOL loadKeyCM(
    ECM_PARAMS_t* ecm);

BOOL createKeyFnc(
    ECM_PARAMS_t* ecm);

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* ECM_INC_ECM_CM_TOOLS_H_ */
