/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        ecm_cm_EventHandler.h

   \brief       Embedded Certificate Manager Event Handler include

   ***

   $Rev: 780 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2017-07-28 15:40:59 +0200 (Fr, 28. Jul 2017) $
****************************************************************************/

#ifndef ECM_INC_ECM_CM_MAIN_H_
#define ECM_INC_ECM_CM_MAIN_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/**
This function is used to start the ECM CM Version

\param[in] argc
    Amount of Parameters from the commandline

\param[in] argv
    Array of commandline Parameters

\return int
\retval Return value from Event Handler Thread
*/
int
ecm_cm_main(
    int argc,
    char *argv[]);

int
loadCRLandUpdateTime(
    CERT_LIST_s* certList,
    CR_LIST_t** cr_List,
    ull_time_t* time,
    CRL_HASHES_t** crlHashes,
    STATUS_s *stat);

BOOL
ecmCmCheckForErrors (
    ECM_PARAMS_t *ecm,
    BOOL ignoreDeviceCertCrl );

BOOL
ecmCmStoreCrls (
    ECM_PARAMS_t *ecm );

BOOL
ecmCmStoreCerts (
    ECM_PARAMS_t *ecm );

BOOL
ecmCmSetStatus (
    STATUS_s *stat,
    EXT_IF_ERROR_CODES_t err,
    char* str,
    char* url);

BOOL
ecmClearStatus (
    STATUS_s *stat );

BOOL
ecmCmRemoveCertFromList (
    char *subject,
    CERT_LIST_s *lst );

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* ECM_INC_ECM_CM_MAIN_H_ */
