/***************************************************************************
 * Copyright                                                               *
 *                                                                         *
 *     ESCRYPT GmbH - Embedded Security       ESCRYPT Inc.                 *
 *     Zentrum fuer IT-Sicherheit             315 E Eisenhower Parkway     *
 *     Lise-Meitner-Allee 4                   Suite 214                    *
 *     44801 Bochum                           Ann Arbor, MI 48108          *
 *     Germany                                USA                          *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        watchdog.h

   \brief       User implementation of Watchdog function

   This file provides a dummy implementation of the watchdog function
   EscWatchdog_CallStatic, which is called in modules which support
   a watchdog, but don't receive a watchdog function pointer
   as argument, e.g. the ECC module.

   The dummy implementation basically does nothing, it just returns.
   To implement a static watchdog handler, edit this file
   or provide a EscWatchdog_CallStatic function in a different
   location. The prototype of this function is located in cycurlib_config.h.

   $Rev: 937 $

 */
/***************************************************************************/

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/
#include "../inc/watchdog.h"

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DEFINITIONS                                                          *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. IMPLEMENTATION OF FUNCTIONS                                          *
 ***************************************************************************/
#ifdef Esc_HAS_WATCHDOG
void
EscWatchdog_CallStatic(
    void )
{
    ;
}

#endif

/***************************************************************************
 * 6. END                                                                  *
 ***************************************************************************/
