/******************************************************************
 *FILE: UserEncryptDecrypt_TokenConvert.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#ifndef UPGRADE_USERENCRYPTDECRYPT_TOKENCONVERT_H_
#define UPGRADE_USERENCRYPTDECRYPT_TOKENCONVERT_H_

#include <map>

#include "UserEncryptDecrypt_IConvert.h"

class TokenConvert : public IConvert {
 public:
  /**
   * @brief Constructor for the class.
   */
  TokenConvert();

  /**
   * @brief This function converts the provided data to the previously provided
   * destination version.
   *
   * @param data is the data that was generated by our lib that may require
   * upgrade.
   * @param sourceVersion is the current version of the system.
   * @param destinationVersion is the version the data needs to be upgraded to.
   *
   * @return returns the upgraded data.
   */
  std::vector<unsigned char> convertData(std::vector<unsigned char> data,
                                         int sourceVersion,
                                         int destinationVersion);
  /**
   * @brief This function initiates the class parameters.
   */
  void init();

 private:
  std::map<int, std::map<int, std::function<std::vector<unsigned char>(
                                  std::vector<unsigned char>)>>>
      _mapTokenFunction;
};

#endif /* UPGRADE_USERENCRYPTDECRYPT_TOKENCONVERT_H_ */
