/******************************************************************
*FILE: UserEncryptDecrypt_TokenConvert.cpp
*SW-COMPONENT: UserEncryptDecrypt
*DESCRIPTION: UserEncryptDecrypt
*COPYRIGHT: © 2018 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#include "UserEncryptDecrypt_TokenConvert.h"

TokenConvert::TokenConvert() : IConvert() {}

std::vector<unsigned char> TokenConvert::convertData(
    std::vector<unsigned char> data, int sourceVersion,
    int destinationVersion) {
  if (isConversionNeeded(sourceVersion, destinationVersion)) {
    return _mapTokenFunction[sourceVersion][destinationVersion](data);
  } else {
    THROW_UED_EXCEPTION(ErrType::UPGRADE_NotInScope);
  }
}

void TokenConvert::init() {
  convertionIsNeeded(UED_VERSION(0, 1, 0), UED_VERSION(1, 0, 0), true);
  convertionIsNeeded(UED_VERSION(1, 0, 0), UED_VERSION(0, 0, 0), false);

  _mapTokenFunction[UED_VERSION(0, 1, 0)][UED_VERSION(1, 0, 0)] =
      std::bind(TokenConvert::noop, std::placeholders::_1);
  _mapTokenFunction[UED_VERSION(1, 0, 0)][UED_VERSION(0, 1, 0)] =
      std::bind(TokenConvert::noop, std::placeholders::_1);
}
