/******************************************************************
 *FILE: UserEncryptDecrypt_Notifier.cpp
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#include "upgrade/UserEncryptDecrypt_Notifier.h"
#include <algorithm>

Notifier::Notifier() {}

Notifier::~Notifier() {}

void Notifier::addObserver(ConversionProcess::Observer& observer) {
  _observerList.push_front(&observer);
}

void Notifier::removeObserver(ConversionProcess::Observer& observer) {
  if (std::find(_observerList.begin(), _observerList.end(), &observer) !=
      _observerList.end()) {
    _observerList.remove(&observer);
  }
}

void Notifier::notifyAllObservers() {
  for (auto it : _observerList) {
    it->onUpgrade();
  }
}
