/******************************************************************
 *FILE: UserEncryptDecrypt_DataConvert.cpp
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#include "UserEncryptDecrypt_DataConvert.h"
#include "backends/UserEncryptDecrypt_BackendManager.h"
#include "backends/sdc/UserEncryptDecrypt_SDCBackend.h"

DataConvert::DataConvert() : IConvert() {}

std::vector<unsigned char> DataConvert::convertData(
    std::vector<unsigned char> data, int sourceVersion,
    int destinationVersion) {
  if (isConversionNeeded(sourceVersion, destinationVersion)) {
    std::vector<unsigned char> rawData =
        _encryptFunctionMap[sourceVersion][destinationVersion](data);
    std::vector<unsigned char> encData =
        _decryptFunctionMap[sourceVersion][destinationVersion](rawData);
    BackendManager::getInstance()->get<SDCBackend>()->Overwrite(rawData);
    return encData;
  } else {
    THROW_UED_EXCEPTION(ErrType::UPGRADE_NotInScope);
  }
}

void DataConvert::init() {
  convertionIsNeeded(UED_VERSION(0, 1, 0), UED_VERSION(1, 0, 0), true);
  convertionIsNeeded(UED_VERSION(1, 0, 0), UED_VERSION(0, 1, 0), false);

  _encryptFunctionMap[UED_VERSION(0, 1, 0)][UED_VERSION(1, 0, 0)] =
      std::bind(DataConvert::noop, std::placeholders::_1);
  _encryptFunctionMap[UED_VERSION(1, 0, 0)][UED_VERSION(0, 1, 0)] =
      std::bind(DataConvert::noop, std::placeholders::_1);
  _decryptFunctionMap[UED_VERSION(0, 1, 0)][UED_VERSION(1, 0, 0)] =
      std::bind(DataConvert::noop, std::placeholders::_1);
  _decryptFunctionMap[UED_VERSION(1, 0, 0)][UED_VERSION(0, 1, 0)] =
      std::bind(DataConvert::noop, std::placeholders::_1);
}
