/******************************************************************
 *FILE: UserEncryptDecrypt_UserIDDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_USERIDDOMAIN_H
#define USERENCRYPTDECRYPT_USERIDDOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <sys/stat.h>
#include <string>
#include "UserEncryptDecrypt_IDomain.h"

/**
 * Class to ensure the robustness of a userID format
 */
class UserID {
 private:
  unsigned int _val;

 public:
  UserID(const unsigned int& data) : _val(data){};

  const unsigned int get() const { return _val; }
};

/**
 * This function validate if a userID is valid in its defined domain
 */
template <>
void isValidInDomain<UserID>(const UserID& d) throw(ErrorMessage) {
  const unsigned int data = d.get();

  if (data < 0) {
    THROW_UED_EXCEPTION(ErrType::AUTH_UserIDNotValid);
  }
}

#endif  // USERENCRYPTDECRYPT_USERIDDOMAIN_H
