/******************************************************************
 *FILE: UserEncryptDecrypt_SaltDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_SALTDOMAIN_H
#define USERENCRYPTDECRYPT_SALTDOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <sys/stat.h>
#include <vector>
#include "UserEncryptDecrypt_IDomain.h"

/**
 * Class to ensure the robustness of a Salt format
 */
class Salt : public std::vector<unsigned char> {
 public:
  Salt(const std::vector<unsigned char>& data)
      : std::vector<unsigned char>(data){};
};

/**
 * This function validate if a Salt valid in its defined domain.
 */
template <>
void isValidInDomain<Salt>(const Salt& d) throw(ErrorMessage) {
  std::vector<unsigned char> data = d;
#ifdef TESTING
  if (data.empty()) {
#else
  if (data.empty() || data.size() < 16 ||
      data.size() > std::numeric_limits<int>::max()) {
#endif
    THROW_UED_EXCEPTION(ErrType::AUTH_SaltNotValid);
  }
}

#endif  // USERENCRYPTDECRYPT_SALTDOMAIN_H
