/******************************************************************
 *FILE: UserEncryptDecrypt_IDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_IDOMAIN_H
#define USERENCRYPTDECRYPT_IDOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>

/**
 * This function is the template fall back for when the domain type is not
 * defined
 */
template <typename T>
static void isValidInDomain(const T& data) throw(ErrorMessage) {
  THROW_UED_EXCEPTION(ErrType::DOMAIN_notValid);
};

#endif  // USERENCRYPTDECRYPT_IDOMAIN_H
