/******************************************************************
 *FILE: UserEncryptDecrypt_User.cpp
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2017 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/ /*
/**
* @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
* @date Dec, 2017
*/

#include "core/user/UserEncryptDecrypt_User.h"
#include <backends/sdc/UserEncryptDecrypt_SDCBackend.h>
#include "UserEncryptDecrypt_UserManager.h"
#include "UserEncryptDecrypt_Utils.h"
#include "core/UserEncryptDecrypt_Configurations.h"

User::User(unsigned int userID, std::vector<unsigned char> hashPassSalt,
           unsigned int wrapperKeyID, std::vector<unsigned char> encDataKey,
           std::vector<unsigned char> hashDataKey,
           std::vector<unsigned char> hashWrapperKey,
           std::vector<unsigned char> salt)
    : _userID(userID),
      _hashPassSalt(hashPassSalt),
      _wrapperKeyID(wrapperKeyID),
      _encDataKey(encDataKey),
      _hashDataKey(hashDataKey),
      _hashWrapperKey(hashWrapperKey),
      _dataKeyID(boost::none),
      _salt(salt) {}

User::User(unsigned int userID, unsigned int wrapperKeyID,
           std::vector<unsigned char> encDataKey,
           std::vector<unsigned char> hashDataKey,
           std::vector<unsigned char> hashWrapperKey)
    : _userID(userID),
      _hashPassSalt(boost::none),
      _wrapperKeyID(wrapperKeyID),
      _encDataKey(encDataKey),
      _hashDataKey(hashDataKey),
      _hashWrapperKey(hashWrapperKey),
      _dataKeyID(boost::none) {}

User::~User() {}

std::string User::createMUK() {
  char _delimiter =
      Configurations::getInstance()->get<char>(Configurations::Conf::DELIMITER);
  std::string encoded_hash;
  std::string encoded_salt;
  std::string textToWrite;

  if (_hashPassSalt.is_initialized()) {
    encoded_hash =
        base64_encode(_hashPassSalt.get().data(), _hashPassSalt.get().size());
  }

  if (_salt.is_initialized()) {
    encoded_salt = base64_encode(_salt.get().data(), _salt.get().size());
  }

  textToWrite += _delimiter;
  textToWrite += std::to_string(_userID);
  textToWrite += _delimiter;
  textToWrite += encoded_hash;
  textToWrite += _delimiter;
  textToWrite += std::to_string(_wrapperKeyID);
  textToWrite += _delimiter;
  textToWrite += base64_encode(_encDataKey.data(), _encDataKey.size());
  textToWrite += _delimiter;
  textToWrite += base64_encode(_hashDataKey.data(), _hashDataKey.size());
  textToWrite += _delimiter;
  textToWrite += base64_encode(_hashWrapperKey.data(), _hashWrapperKey.size());
  textToWrite += _delimiter;
  textToWrite +=
      std::to_string(UserManager::getInstance()->isMasterUser(_userID));
  textToWrite += _delimiter;
  textToWrite += encoded_salt;
  textToWrite += _delimiter;
  textToWrite += base64_encode(_encWrapperKey.data(), _encWrapperKey.size());
  textToWrite += _delimiter;

  return textToWrite;
}

unsigned int User::getUserID() { return _userID; }

boost::optional<std::vector<unsigned char>> User::getHashPassSalt() {
  return _hashPassSalt;
}

unsigned int& User::getWrapperKeyID() { return _wrapperKeyID; }

std::vector<unsigned char>& User::getEncDataKey() { return _encDataKey; }

std::vector<unsigned char> User::getHashDataKey() { return _hashDataKey; }

std::vector<unsigned char>& User::getHashWrapperKey() {
  return _hashWrapperKey;
}

boost::optional<unsigned int> User::getDataKeyID() { return _dataKeyID; }

boost::optional<std::vector<unsigned char>> User::getSalt() { return _salt; }

void User::setHashPassSalt(
    boost::optional<std::vector<unsigned char>> hashPassSalt) {
  _hashPassSalt = hashPassSalt;
}
void User::setWrapperKeyID(unsigned int& wrapperKeyID) {
  _wrapperKeyID = wrapperKeyID;
}

void User::setEncDataKey(std::vector<unsigned char>& encDataKey) {
  _encDataKey = encDataKey;
}

void User::setHashWrapperKey(std::vector<unsigned char>& hashWrapperKey) {
  _hashWrapperKey = hashWrapperKey;
}

void User::setDataKeyID(boost::optional<unsigned int> dataKeyID) {
  _dataKeyID = dataKeyID;
}

void User::setSalt(boost::optional<std::vector<unsigned char>> salt) {
  _salt = salt;
}

const std::vector<unsigned char>& User::getOldEncWrapperKey() const {
  return _oldEncWrapperKey;
}

void User::setOldEncWrapperKey(std::vector<unsigned char>& oldEncWrapperKey) {
  _oldEncWrapperKey = oldEncWrapperKey;
}

const std::vector<unsigned char>& User::getOldEncDataKey() const {
  return _oldEncDataKey;
}

void User::setOldEncDataKey(const std::vector<unsigned char>& oldEncDataKey) {
  _oldEncDataKey = oldEncDataKey;
}

const std::vector<unsigned char>& User::getEncWrapperKey() const {
  return _encWrapperKey;
}

void User::set_encWrapperKey(const std::vector<unsigned char>& encWrapperKey) {
  _encWrapperKey = encWrapperKey;
}
