/**************************************************************************//**
 * \file       Sds_ViewDB.h
 *
 * Exported interface of the view data base.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef Sds_ViewDB_h
#define Sds_ViewDB_h


//lint -efile(451, Sds_ViewDB.dat) repeatedly included but does not have a standard include guard - jnd2hi


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <string>
#include <map>
#include <vector>


enum Sds_BehaviorId
{
#define SDS_BEHAVIOR(name)     name,
#include "Sds_ViewDB.dat"
#undef SDS_BEHAVIOR
   SDS_BEHAVIOR_ID_LIMIT
};


struct SelectableText
{
   std::string text;
   bool isSelectable;
   Sds_BehaviorId enBehavior;
};


std::string Sds_ViewDB_getLayout(const std::string& viewId);
std::string Sds_ViewDB_oGetTemplateString(const std::string& templateId);
std::string Sds_ViewDB_oGetHeadline(const std::string& viewId);
std::vector<SelectableText> Sds_ViewDB_oGetCommandList(std::map<std::string, std::string> const& conditions, const std::string& viewId);
std::vector<std::string> Sds_ViewDB_oGetExampleCommandList(std::map<std::string, std::string> const& variables, const std::string& viewId);
std::vector<std::string> Sds_ViewDB_oGetSubCommandList(std::map<std::string, std::string> const& variables, const std::string& viewId, tU32 cursorIndex);
std::vector<std::string> Sds_ViewDB_oGetSubCommandList(std::map<std::string, std::string> const& variables, const std::string& viewId);
std::string Sds_ViewDB_oGetHelpline(const std::string& viewId);
std::string Sds_ViewDB_oGetInfo(const std::string& viewId);
std::string Sds_ViewDB_getGrammarId(const std::string& viewId, unsigned int itemIndex, std::map<std::string, std::string> screenVariableData);
std::string Sds_ViewDB_getPromptId(const std::string& viewId, unsigned int itemIndex, std::map<std::string, std::string> screenVariableData);
tBool Sds_ViewDB_getIsSelected(const std::string& viewId, unsigned int itemIndex, std::map<std::string, std::string> screenVariableData);
std::string Sds_HandOverDB_getSdsInput(const int hmiScreenId, const std::string& handOverType, const bool stateAvailable = true);
Sds_BehaviorId Sds_ViewDB_oGetHeadlineBehaviorId(const std::string& viewId);
Sds_BehaviorId Sds_ViewDB_oGetInfoBehaviorId(const std::string& viewId);
Sds_BehaviorId Sds_ViewDB_oGetHelplineBehaviorId(const std::string& viewId);
#endif
