/**************************************************************************//**
 * \file       SqliteDB.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef SqliteDB_h
#define SqliteDB_h


#include <string>


struct sqlite3;
struct sqlite3_stmt;

namespace sdsa {
namespace sqlite {


class SqliteDB
{
   public:
      SqliteDB(const ::std::string& path);
      virtual ~SqliteDB();
      void open();
      void close();
      void beginTransaction();
      void endTransaction();
      int exec(const std::string& query);
      void prepare(const std::string& query);
      void step();
      bool columnSelected();
      int getColumnInt(int column, int defaultValue = 0);
      ::std::string getColumnText(int column, const ::std::string& defaultValue = "");
      void finalize();
      static std::string escape(const std::string& text);

   protected:
      virtual void setup() = 0;

   private:
      void checkDeletionRequired(int errorCode);

      ::std::string _path;
      sqlite3* _database;
      sqlite3_stmt* _statement;
      int _lastResult;
      bool _deleteDatabase;
};


};
};


#endif
