/**************************************************************************//**
 * \file       TVDatabaseHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef TVDatabaseHandler_h
#define TVDatabaseHandler_h


#include "sds_tv_fi/SdsTvService.h"
#include "SqliteDB.h"


class TVDatabaseHandler : public sdsa::sqlite::SqliteDB
{
   public:
      TVDatabaseHandler();
      virtual ~TVDatabaseHandler();

      void deleteChannelList();
      void storeChannel(const sds_tv_fi::SdsTvService::TVChannelItem& channel);
      void updateChecksum();

   protected:
      virtual void setup();
};


#endif
