/**************************************************************************//**
 * \file       Sds2FmDbService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2FmDbService.h"


Sds2FmDbService::Sds2FmDbService() : SdsFmServiceStub("FmDbServicePort")
{
}


Sds2FmDbService::~Sds2FmDbService()
{
}


void Sds2FmDbService::onStoreRDSChannelNamesRequest(const ::boost::shared_ptr< sds_fm_fi::SdsFmService::StoreRDSChannelNamesRequest >& request)
{
   FmRdsStationDb db;
   db.open();
   db.beginTransaction();
   db.deleteStationList();
   db.storeStationList(request->getChannelList());
   db.updateChecksum();
   db.endTransaction();
   db.close();
   sendStoreRDSChannelNamesResponse();
}


void Sds2FmDbService::onStoreHDChannelNamesRequest(const ::boost::shared_ptr< sds_fm_fi::SdsFmService::StoreHDChannelNamesRequest >& request)
{
   FmHdStationDb db;
   db.open();
   db.beginTransaction();
   db.deleteStationList();
   db.storeStationList(request->getChannelList());
   db.updateChecksum();
   db.endTransaction();
   db.close();
   sendStoreHDChannelNamesResponse();
}
