/**************************************************************************//**
 * \file       FmRdsStationDb.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "FmRdsStationDb.h"
#include <stdio.h>


#define QUERY_CREATE_FM_STATION_LIST_TABLE      "CREATE TABLE FMStationList( object_id INTEGER, frequency INTEGER, shortstation_name CHAR(100), audioProgram INTEGER);"

#define FORMAT_QUERY_UPDATE_FM_STATION_LIST     "INSERT INTO FMStationList (object_id, frequency, shortstation_name, audioProgram) VALUES ('%u', '%u', '%s', '%u');"

#define QUERY_CREATE_FM_CHECKSUM_TABLE          "CREATE TABLE FM_Checksum( fm_timestamp DATETIME PRIMARY KEY DEFAULT CURRENT_TIMESTAMP);"
#define FORMAT_QUERY_UPDATE_FM_TIME_STAMP       "INSERT OR REPLACE INTO FM_Checksum (fm_timestamp) values (CURRENT_TIMESTAMP);"
#define FORMAT_QUERY_DELETE_FM_TIME_STAMP       "DELETE FROM FM_Checksum;"
#define QUERY_VIEW_FM_CHECKSUM                  "CREATE VIEW FMChecksum AS SELECT fm_timestamp FROM FM_Checksum;"

#define QUERY_VIEW_FM_RDS_SHORT_NAME                     "CREATE VIEW RDSShortname AS SELECT shortstation_name AS RDSShortname,  ((frequency<<16)/10 + (object_id & 0xFFFF)) AS StationID, object_id AS RDS_PI FROM FMStationList WHERE shortstation_name != '' ;"
#define QUERY_DELETE_ALL_DATA_FM_STATION_LIST            "delete from FMStationList;"


#define MAX_QUERY_LEN       1024 /* = 1 KB. Note: Normally 8 KB is required but for SAAL 1KB is sufficient */


FmRdsStationDb::FmRdsStationDb()
   : SqliteDB("/tmp/speech/radio/FM_RDS_tunerDB.db")
{
}


FmRdsStationDb::~FmRdsStationDb()
{
}


void FmRdsStationDb::setup()
{
   exec(QUERY_CREATE_FM_STATION_LIST_TABLE);
   exec(QUERY_CREATE_FM_CHECKSUM_TABLE);
   exec(QUERY_VIEW_FM_RDS_SHORT_NAME);
   exec(QUERY_VIEW_FM_CHECKSUM);
}


void FmRdsStationDb::deleteStationList()
{
   exec(QUERY_DELETE_ALL_DATA_FM_STATION_LIST);
}


void FmRdsStationDb::storeStationList(const ::std::vector<sds_fm_fi::SdsFmService::FMChannelItem>& stationList)
{
   for (size_t i = 0; i < stationList.size(); ++i)
   {
      storeStation(stationList[i]);
   }
}


void FmRdsStationDb::storeStation(const sds_fm_fi::SdsFmService::FMChannelItem& station)
{
   char query[MAX_QUERY_LEN];
   snprintf(
      query,
      sizeof(query),
      FORMAT_QUERY_UPDATE_FM_STATION_LIST,
      station.getObjectID(),
      station.getFrequency(),
      escape(station.getStationName()).c_str(),
      0);
   query[sizeof(query) - 1] = 0;    // ensure terminating zero
   exec(query);
}


void FmRdsStationDb::updateChecksum()
{
   exec(FORMAT_QUERY_DELETE_FM_TIME_STAMP);
   exec(FORMAT_QUERY_UPDATE_FM_TIME_STAMP);
}
