/**************************************************************************//**
 * \file       DabDatabaseHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef DabDatabaseHandler_h
#define DabDatabaseHandler_h


#include "SqliteDB.h"
#include "sds_dab_fi/SdsDabService.h"


class DabDatabaseHandler : public sdsa::sqlite::SqliteDB
{
   public:
      DabDatabaseHandler();
      virtual ~DabDatabaseHandler();
      void deleteStationList();
      void storeStationList(const ::std::vector<sds_dab_fi::SdsDabService::DABChannelItem>& stationList);
      void updateChecksum();

   protected:
      virtual void setup();

   private:
      void storeStation(const sds_dab_fi::SdsDabService::DABChannelItem& station);
};


#endif
