/**************************************************************************//**
 * \file       Sds2AppDbService.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef Sds2AppDbService_h
#define Sds2AppDbService_h


#include "sds_app_fi/SdsAppServiceStub.h"
#include "AppDatabaseHandler.h"


class Sds2AppDbService : public sds_app_fi::SdsAppService::SdsAppServiceStub
{
   public:
      Sds2AppDbService();
      virtual ~Sds2AppDbService();

      virtual void onStoreAppNamesRequest(const ::boost::shared_ptr< sds_app_fi::SdsAppService::StoreAppNamesRequest >& request);
      virtual void onGetAppNamesListRequest(const ::boost::shared_ptr< sds_app_fi::SdsAppService::GetAppNamesListRequest>& request);

   private:
      AppDatabaseHandler _appDatabaseHandler;
};


#endif
