/**************************************************************************//**
 * \file       Sds2AppDbService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2AppDbService.h"


Sds2AppDbService::Sds2AppDbService() : SdsAppServiceStub("AppDbServicePort")
{
}


Sds2AppDbService::~Sds2AppDbService()
{
}


void Sds2AppDbService::onStoreAppNamesRequest(const ::boost::shared_ptr< sds_app_fi::SdsAppService::StoreAppNamesRequest >& request)
{
   _appDatabaseHandler.open();
   _appDatabaseHandler.beginTransaction();
   _appDatabaseHandler.deleteAppList();
   _appDatabaseHandler.storeAppList(request->getAppList());
   _appDatabaseHandler.updateChecksum(request->getAppList().getChecksum());
   _appDatabaseHandler.endTransaction();
   _appDatabaseHandler.close();
   sendStoreAppNamesResponse();
}


void Sds2AppDbService::onGetAppNamesListRequest(const ::boost::shared_ptr< sds_app_fi::SdsAppService::GetAppNamesListRequest>& /*request*/)
{
   sendGetAppNamesListResponse(_appDatabaseHandler.getAppNamesList());
}
