/**************************************************************************//**
 * \file       AppDatabaseHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef AppDatabaseHandler_h
#define AppDatabaseHandler_h


#include "sds_app_fi/SdsAppService.h"
#include "SqliteDB.h"


class AppDatabaseHandler : public sdsa::sqlite::SqliteDB
{
   public:
      AppDatabaseHandler();
      virtual ~AppDatabaseHandler();

      void deleteAppList();
      void storeAppList(const sds_app_fi::SdsAppService::AppList& appList);
      void updateChecksum(unsigned int checksum);
      ::std::vector< ::std::string > getAppNamesList();

   protected:
      void setup();

   private:
      void storeApp(const sds_app_fi::SdsAppService::AppDataList& app, uint32 appIndex);
      uint32 getLanguageCode(
         const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList , unsigned int index) const;
      uint32 getCountryCode(
         const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList, unsigned int index) const;
      ::std::string getLanguageString(const std::string& languageAndCountry) const;
      ::std::string getCountryString(const std::string& languageAndCountry) const;
      uint32 isoNameToIsoCode(const std::string& isoName) const;
      const char* getPhoneme(
         const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList,
         size_t index) const;

      ::std::vector< ::std::string > _appNameList;
};


#endif
