/**************************************************************************//**
 * \file       clSDS_View.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_View_h
#define clSDS_View_h


#include "view_db/Sds_ViewDB.h"
#include "application/clSDS_ListItems.h"
#include "sds_gui_fi/SdsGuiServiceStub.h"
#include "sds_gui_fi/PopUpServiceStub.h"

#include <string>


class clSDS_View
{
   public:
      virtual ~clSDS_View();
      clSDS_View();

      tVoid vCreateView(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         const std::string& viewId,
         std::vector<clSDS_ListItems>& oListItems,
         const std::map<std::string, std::string>& oScreenVariableData,
         std::string enTemplateId,
         const std::map<std::string, std::string>& oHeaderValueMap,
         uint32 cursorIndex,
         uint32 pageNumber,
         unsigned int maxItemsperPage);

      tVoid vCreateViewHeader(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::string enTemplateId,
         const std::map<std::string, std::string>& oHeaderValueMap,
         const std::string& viewId = "") const;

      unsigned int getCommandListCount() const;

   private:
      tVoid vInitView(sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal) const;

      tVoid vWriteHeadline(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         const std::map<std::string, std::string>& oScreenVariableData,
         std::string enTemplateId,
         std::map<std::string, std::string> const& oHeaderValueMap,
         const std::string& viewId);

      tVoid vWriteHelpline(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         const std::map<std::string, std::string>& oScreenVariableData,
         std::string enTemplateId,
         std::map<std::string, std::string> const& oHeaderValueMap,
         const std::string& viewId) const;

      tVoid vWriteInfo(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         const std::map<std::string, std::string>& oScreenVariableData,
         std::string enTemplateId,
         std::map<std::string, std::string> const& oHeaderValueMap,
         const std::string& viewId) const;

      std::string splitStringWithDelimiter(std::string& stringToSplit, std::string& delimiter, size_t part) const;

      std::string mapInfoFromHeadline(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::string oHeaderString,
         std::map<std::string, std::string> const& oHeaderValueMap,
         const std::string& viewId) const;

      std::string oResolveVariableContent(
         std::string oTemplateString,
         std::map<std::string, std::string> const& oHeaderValueMap,
         bool isClearRequired = true) const;

      tVoid vWriteCommands(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::map<std::string, std::string> const& oScreenVariableData,
         const std::string& viewId,
         tU32 pageNumber);

      tVoid vWriteListData(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::vector<clSDS_ListItems>& oListItems) const;

      sds_gui_fi::PopUpService::TextAttribute colorToTextAttribute(clSDS_ListItems::tenColorofText colorOfText) const;

      std::string oResolveNumberFormat(const std::string& oTemplateString) const;

      tVoid vWriteSubCommands(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::map<std::string, std::string> const& variables,
         const std::string& viewId,
         tU32 cursorIndex) const;

      tVoid vWriteSubCommands(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::map<std::string, std::string> const& variables,
         const std::string& viewId) const;

      tVoid vWriteExampleCommands(
         sds_gui_fi::PopUpService::PopupRequestSignal& viewPopupRequestSignal,
         std::map<std::string, std::string> const& variables,
         const std::string& viewId) const;

      tVoid fillTextFieldData(
         sds_gui_fi::PopUpService::TextField& textField,
         std::string tagName,
         std::string value,
         sds_gui_fi::PopUpService::TextAttribute colorOfText) const;

      std::string& clearUnresolvedVariables(std::string& text) const;

      std::string& removeUnnecessarySeparators(std::string& text) const;

      std::string oSplitHeaderContent(std::string& stringToSplit, size_t index) const;

      unsigned int _commandListCount;
      unsigned int _maxItemsPerPage ;
      std::string _lastViewId;
};


#endif
