/**************************************************************************//**
 * \file       clSDS_Userwords.h
 *
 * Userword handling related functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Userwords_h
#define clSDS_Userwords_h


#include "application/clSDS_SDSStatusObserver.h"
#include "external/sds2hmi_fi.h"
#include "sds_gui_fi/SdsPhoneServiceProxy.h"
#include "application/clSDS_PhoneStatusObserver.h"

class clSDS_SDSStatus;
class clSDS_SdsControl;
class clSDS_QuickDialList;

class clSDS_Userwords  : public clSDS_SDSStatusObserver
   , public clSDS_PhoneStatusObserver
{
   public:
      ~clSDS_Userwords();
      clSDS_Userwords(clSDS_SDSStatus* pSDSStatus, clSDS_SdsControl* pSdsControl, clSDS_QuickDialList* pQuickDialList);
      uint32 getContactID() const;
      virtual tVoid vSDSStatusChanged();
      tVoid vSetActiveProfile(tU32 u32ActiveProfileNum);
      tVoid vDeleteAllUserwords(tU32 u32UWProfile, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void handleUserWordActions(const ::boost::shared_ptr< sds_gui_fi::SdsPhoneService::VoiceTagActionRequest >& request);
      void phoneProfileChanged(uint8 profileID);

   private:
      tBool bIsVoiceControlIdle() const;

      tVoid vDeleteUserword(tU32 u32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      tBool bSetSDSUser();
      void recordUserWord(unsigned long u32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void replaceUserWord(unsigned long u32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void playUserWord(unsigned long u32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);

      clSDS_SDSStatus* _pSDSStatus;
      clSDS_SdsControl* _pSdsControl;
      clSDS_QuickDialList* _pQuickDialList;
      tU32 _u32ActiveProfileNum;
      tU32 _u32CurrentSDSUser;
      tU32 _u32AvailableProfiles;
      uint32 _userWordListID;
};


#endif
