/**************************************************************************//**
 * \file       clSDS_StringVarList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_StringVarList_h
#define clSDS_StringVarList_h


#include <map>
#include <string>


class clSDS_StringVarList
{
   public:
      virtual ~clSDS_StringVarList();
      clSDS_StringVarList();

      static void vSetVariable(const std::string& oVariable, const std::string& oValue);
      static std::string oResolveVariables(const std::string& oString);
      static const std::map<std::string, std::string>& getVariableList();
      static void printStaticVariables();

   private:
      static std::map<std::string, std::string> _mapVariableList;
};


#endif
