/**************************************************************************//**
 * \file       clSDS_StringVarList.cpp
 *
 * clSDS_StringVarList class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/clSDS_StringVarList.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_StringVarList.cpp.trc.h"
#endif

std::map<std::string, std::string> clSDS_StringVarList::_mapVariableList;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_StringVarList::~clSDS_StringVarList()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_StringVarList::clSDS_StringVarList()
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_StringVarList::vSetVariable(const std::string& oVariable, const std::string& oValue)
{
   _mapVariableList[oVariable] = oValue;
}


/***********************************************************************//**
*
***************************************************************************/
std::string clSDS_StringVarList::oResolveVariables(const std::string& oString)
{
   std::map<std::string, std::string>::const_iterator iter;
   std::string resolved = oString;
   for (iter = _mapVariableList.begin(); iter != _mapVariableList.end(); ++iter)
   {
      while (resolved.find(iter->first) != std::string::npos)
      {
         resolved.replace(resolved.find(iter->first), iter->first.size(), iter->second);
      }
   }
   return resolved;
}


/***********************************************************************//**
*
***************************************************************************/
const std::map<std::string, std::string>& clSDS_StringVarList::getVariableList()
{
   return _mapVariableList;
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_StringVarList::printStaticVariables()
{
   std::map<std::string, std::string>::const_iterator it;
   ETG_TRACE_USR1(("clSDS_StringVarList: size = %u", _mapVariableList.size()));
   for (it = _mapVariableList.begin(); it != _mapVariableList.end(); ++it)
   {
      std::string pair = it->first + " = '" + it->second + "'";
      ETG_TRACE_USR1(("clSDS_StringVarList: %s", pair.c_str()));
   }
}
