/**************************************************************************//**
 * \file       clSDS_SdsControl.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_SdsControl_h
#define clSDS_SdsControl_h

#include "external/sds2hmi_fi.h"

class clSDS_SdsControl
{
   public:

      virtual ~clSDS_SdsControl()
      {
      }
      clSDS_SdsControl()
      {
      }

      virtual void vSendPTTLongPressEvent() = 0 ;
      virtual void vSendBackEvent() = 0;
      virtual void vAbortDialog() = 0;
      virtual void vSendPttEvent(tU32 u32Context) = 0;
      virtual void vSetSpeaker(tU16 u16SpeakerId) = 0;
      virtual void vRequestAllSpeakers() = 0;
      virtual void vDeleteUserWord(tU32 tU32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void vDeleteAllUserWords(tU32 tU32UWProfile, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void vSetUWProfile(tU32 u32NewSDSUser, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void vClearPrivateData() = 0;
      virtual void sendEnterManualMode() = 0;
      virtual void sendFocusMoved(unsigned int focusIndex) = 0;
      virtual void sendNextPageRequest() = 0;
      virtual void sendPreviousPageRequest() = 0;
      virtual void sendListSelectRequest(unsigned int selectedIndex) = 0;
      virtual void sendSelectRequest(unsigned int selectedIndex) = 0;
      virtual void sendCancelDialog() = 0;
      virtual void recordUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void replaceUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void playUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain) = 0;
      virtual void sendEnterPauseMode() = 0;
      virtual void sendExitPauseMode() = 0;
      virtual void sendDataHandoverPTTRequest(sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType entryPoint,
                                              sds2hmi_fi_tcl_e8_Data_Exchange_Type::tenType dataexchangeType,
                                              sds2hmi_fi_tcl_e8_WordType::tenType wordType,
                                              std::string infoString) = 0;
};


#endif
