/**************************************************************************//**
 * \file       clSDS_QuickDialRelationshipUpdater.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_QuickDialRelationshipUpdater_h
#define clSDS_QuickDialRelationshipUpdater_h


#include "application/clSDS_QuickDialListCreator.h"


class clSDS_QuickDialListObserver;


class clSDS_QuickDialRelationshipUpdater
   : public clSDS_QuickDialListCreator
   , public MOST_PhonBk_FI::ListChangeCallbackIF
   , public asf::core::ServiceAvailableIF
{
   public:
      clSDS_QuickDialRelationshipUpdater(::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy);

      void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      void onListChangeError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MOST_PhonBk_FI::ListChangeError >& error);
      void onListChangeStatus(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy, const ::boost::shared_ptr< MOST_PhonBk_FI::ListChangeStatus >& status);

      //Override from clSDS_PhoneStatusObserver
      void phoneStatusChanged(uint8 deviceHandle, most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus status);
      //Override from clSDS_QuickDialListCreator
      void onQuickDialListDataChanged();
      void addQuickDialDataToList(const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);
      void clearQuickDialData();

      //public method
      void addObserver(clSDS_QuickDialListObserver* pObserver);

   private:
      std::set<std::string> _quickDialRelationshipSet;
      std::vector<clSDS_QuickDialListObserver*> _observerList;
};


#endif
