/**************************************************************************//**
 * \file       clSDS_QuickDialRelationshipUpdater.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "clSDS_QuickDialRelationshipUpdater.h"
#include "application/clSDS_QuickDialListCreator.h"
#include "application/clSDS_QuickDialListObserver.h"


using namespace MOST_PhonBk_FI;
using namespace most_PhonBk_fi_types;


clSDS_QuickDialRelationshipUpdater::clSDS_QuickDialRelationshipUpdater(::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy)
   : clSDS_QuickDialListCreator(phonebookProxy)
{
}


void clSDS_QuickDialRelationshipUpdater::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (proxy == _phonebookProxy)
   {
      _phonebookProxy->sendListChangeUpReg(*this);
   }
}


void clSDS_QuickDialRelationshipUpdater::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (proxy == _phonebookProxy)
   {
      _phonebookProxy->sendListChangeRelUpRegAll();
   }
}


void clSDS_QuickDialRelationshipUpdater::onListChangeError(const::boost::shared_ptr<MOST_PhonBk_FIProxy>& proxy, const::boost::shared_ptr<ListChangeError>& error)
{
}


void clSDS_QuickDialRelationshipUpdater::phoneStatusChanged(uint8 deviceHandle, most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus status)
{
   bool shouldUpdateRelationshipFlags = (deviceHandle != _activeDeviceHandle) || (status != _activeDeviceStatus);
   clSDS_QuickDialListCreator::phoneStatusChanged(deviceHandle, status);
   if (shouldUpdateRelationshipFlags)
   {
      requestQuickDialList();
   }
}


void clSDS_QuickDialRelationshipUpdater::onQuickDialListDataChanged()
{
   for (size_t i = 0; i < _observerList.size(); ++i)
   {
      if (_observerList[i])
      {
         _observerList[i]->onInUseRelationshipsChanged(_quickDialRelationshipSet);
      }
   }
}


void clSDS_QuickDialRelationshipUpdater::addQuickDialDataToList(const::boost::shared_ptr<MOST_PhonBk_FI::GetContactDetailsExtendedResult>& result)
{
   _quickDialRelationshipSet.insert(result->getOContactDetailsExtended().getSCategory());
}


void clSDS_QuickDialRelationshipUpdater::clearQuickDialData()
{
   _quickDialRelationshipSet.clear();
}


void clSDS_QuickDialRelationshipUpdater::onListChangeStatus(const::boost::shared_ptr<MOST_PhonBk_FIProxy>& proxy, const::boost::shared_ptr<ListChangeStatus>& status)
{
   if ((status->getE8ListChangeType() != T_e8_PhonBkListChangeType__e8LCH_CONTENT_CHANGED)
         && (status->getE8ListType() == T_e8_PhonBkListType__e8PHONEBOOK_LIST))
   {
      requestQuickDialList();
   }
}


void clSDS_QuickDialRelationshipUpdater::addObserver(clSDS_QuickDialListObserver* pObserver)
{
   _observerList.push_back(pObserver);
}
