/**************************************************************************//**
 * \file       clSDS_QuickDialListCreator.cpp
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/clSDS_QuickDialListCreator.h"


using namespace MOST_PhonBk_FI;
using namespace most_PhonBk_fi_types;
using namespace most_PhonBk_fi_types_Extended;
using namespace sds_gui_fi::SdsPhoneService;
using namespace most_BTSet_fi_types_Extended;
using namespace asf::core;


/**************************************************************************//**
 *
 ******************************************************************************/
clSDS_QuickDialListCreator::clSDS_QuickDialListCreator(::boost::shared_ptr<MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy)
   : _phonebookProxy(phonebookProxy),
     _requestsCount(0),
     _activeDeviceHandle(0),
     _activeDeviceStatus(T_e8_BTConnectionStatus__e8STATUS_NOT_CONNECT)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::requestQuickDialList()
{
   clearQuickDialData();
   if (T_e8_BTConnectionStatus__e8STATUS_CONNECTED == _activeDeviceStatus)
   {
      _phonebookProxy->sendCreateContactListStart(*this, _activeDeviceHandle,
            T_e8_PhonBkContactListType__VEHICLE, T_e8_PhonBkContactSortType__e8PB_LIST_SORT_POSITION);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onCreateContactListResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListResult >& result)
{
   if (result->getU16ListLength())
   {
      _phonebookProxy->sendRequestPhoneBookListSliceExtendedStart(*this, result->getU16ListHandle(), 0, result->getU16ListLength());
   }
   else
   {
      clearQuickDialData();
      onQuickDialListDataChanged();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onCreateContactListError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onRequestPhoneBookListSliceExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedResult >& result)
{
   _requestsCount = result->getOPhoneBookListSliceResultExtended().size();

   if (_requestsCount)
   {
      for (unsigned int i = 0; i < _requestsCount; i++)
      {
         uint32 contactHandle = result->getOPhoneBookListSliceResultExtended().at(i).getU32ContactHandle();

         _phonebookProxy->sendGetContactDetailsExtendedStart(*this, contactHandle);
      }
   }
   else
   {
      clearQuickDialData();
      onQuickDialListDataChanged();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onRequestPhoneBookListSliceExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onGetContactDetailsExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& /*error*/)
{
   if (_requestsCount > 0)
   {
      _requestsCount--;
   }

   if (_requestsCount == 0)
   {
      onQuickDialListDataChanged();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::onGetContactDetailsExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result)
{
   addQuickDialDataToList(result);

   if (_requestsCount > 0)
   {
      _requestsCount--;
   }

   if (_requestsCount == 0)
   {
      onQuickDialListDataChanged();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_QuickDialListCreator::phoneStatusChanged(uint8 deviceHandle, most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus status)
{
   _activeDeviceHandle = deviceHandle;
   _activeDeviceStatus = status;
}
