/**************************************************************************//**
 * \file       clSDS_QuickDialList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_QuickDialList_h
#define clSDS_QucikDialList_h


#include <string>
#include <vector>


#include "application/clSDS_List.h"
#include "asf/core/Proxy.h"
#include "MOST_PhonBk_FIProxy.h"
#include "sds_gui_fi/SdsPhoneServiceProxy.h"
#include "application/clSDS_QuickDialListCreator.h"


class clSDS_QuickDialList
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public clSDS_QuickDialListCreator
   , public MOST_PhonBk_FI::PreferredPhoneBookSortOrderCallbackIF
{
   public:
      virtual ~clSDS_QuickDialList();
      clSDS_QuickDialList(::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy);

      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tU32 u32GetSize();
      tBool bSelectElement(tU32 u32SelectedIndex);
      std::string oGetSelectedItem(tU32 u32Index);

      void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onPreferredPhoneBookSortOrderError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderError >& error);
      virtual void onPreferredPhoneBookSortOrderStatus(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderStatus >& status);

      virtual std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();
      std::string getRelationship(const std::string& localID) const;

      struct QuickDialContact
      {
         std::string firstName;
         std::string lastName;
         std::string phoneNumber;
         sds2hmi_fi_tcl_e8_PHN_NumberType::tenType phoneNumberType;
         std::string relationship;
      };

   protected:
      //Override from QuickdialListCreator
      void onQuickDialListDataChanged();
      void addQuickDialDataToList(const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);
      void clearQuickDialData();
   private:
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      std::string oGetItem(tU32 u32Index);
      std::string oGetName(tU32 u32Index);
      std::string oGetRelationship(tU32 u32Index);
      std::string oGetPhoneNumber(tU32 u32Index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      std::string toLanguageString(sds2hmi_fi_tcl_e8_PHN_NumberType::tenType phoneNumberType);
      std::string addParanthesis(const std::string& str) const;
      void appendNumberTypeAndRelation(std::string& descriptionString, const QuickDialContact& quickDialListItem);
      std::vector<QuickDialContact> _quickDialListForDisplay;
      sds2hmi_fi_tcl_HMIElementDescription getHmiElementDescriptionItem(unsigned int index);
};


#endif
